/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static void writeObject(File f, Serializable obj) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    public static Object readObject(File f) {
        String fname = f.getName();
        if (fname.endsWith(".gz")) {
            return FileUtils.readGzippedObject(f);
        }
        return FileUtils.readUnzippedObject(f);
    }

    public static Object readUnzippedObject(File f) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] readFile(File f) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(f));
        ArrayList<String> list = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            list.add(line);
        }
        return list.toArray(new String[0]);
    }

    public static File uniqueFile(File dir, String prefix, String extension) throws IOException {
        File f = null;
        int i = 0;
        boolean wasCreated = false;
        while (!wasCreated) {
            f = dir != null ? new File(dir, String.valueOf(prefix) + i + extension) : new File(String.valueOf(prefix) + i + extension);
            wasCreated = f.createNewFile();
            ++i;
        }
        return f;
    }

    public static void writeGzippedObject(File f, Serializable obj) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f))));
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    public static Object readGzippedObject(File f) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f))));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

