/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringEditFeatureVectorSequence
extends FeatureVectorSequence
implements Serializable {
    private int string1Length;
    private int string2Length;
    private String string1;
    private String string2;
    private String[] string1Blocks;
    private String[] string2Blocks;
    private TObjectIntHashMap string1Present;
    private TObjectIntHashMap string2Present;
    private TObjectIntHashMap lexicon;
    private int[] block1Indices;
    private int[] block2Indices;
    private char delim = (char)58;
    private static final char defaultDelimiter = ':';
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public StringEditFeatureVectorSequence(FeatureVector[] featureVectors, String s1, String s2) {
        this(featureVectors, s1, s2, ':');
    }

    public StringEditFeatureVectorSequence(FeatureVector[] featureVectors, String s1, String s2, char delimiter) {
        this(featureVectors, s1, s2, delimiter, null);
    }

    public StringEditFeatureVectorSequence(FeatureVector[] featureVectors, String s1, String s2, HashMap lexic) {
        this(featureVectors, s1, s2, ':', lexic);
    }

    public StringEditFeatureVectorSequence(FeatureVector[] featureVectors, String s1, String s2, char delimiter, HashMap lexic) {
        super(featureVectors);
        this.delim = delimiter;
        this.lexicon = new TObjectIntHashMap();
        if (lexic != null) {
            Set keys = lexic.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                this.lexicon.put((Object)((String)iter.next()), 1);
            }
        }
        this.string1 = s1;
        this.string2 = s2;
        this.string1Length = s1.length() + 2;
        this.string2Length = s2.length() + 2;
        this.string1Blocks = this.string1.split("" + this.delim);
        this.string2Blocks = this.string2.split("" + this.delim);
        this.string1Present = new TObjectIntHashMap();
        this.string2Present = new TObjectIntHashMap();
        this.block1Indices = new int[this.string1Length];
        if (this.string1Blocks.length > 0) {
            int whichBlock = 0;
            this.block1Indices[0] = whichBlock++;
            int i = 0;
            while (i < this.string1Blocks.length) {
                this.string1Present.put((Object)this.string1Blocks[i], 1);
                ++i;
            }
            i = 1;
            while (i < this.string1Length - 1) {
                this.block1Indices[i] = this.string1.charAt(i - 1) == this.delim ? whichBlock++ : -1;
                ++i;
            }
            this.block1Indices[this.string1Length - 1] = -1;
        }
        this.block2Indices = new int[this.string2Length];
        if (this.string2Blocks.length > 0) {
            int whichBlock = 0;
            this.block2Indices[0] = whichBlock++;
            int i = 0;
            while (i < this.string2Blocks.length) {
                this.string2Present.put((Object)this.string2Blocks[i], 1);
                ++i;
            }
            i = 1;
            while (i < this.string2Length - 1) {
                this.block2Indices[i] = this.string2.charAt(i - 1) == this.delim ? whichBlock++ : -1;
                ++i;
            }
            this.block2Indices[this.string2Length - 1] = -1;
        }
    }

    public String getString1() {
        return this.string1;
    }

    public String getString2() {
        return this.string2;
    }

    public int getString1Length() {
        return this.string1Length;
    }

    public int getString2Length() {
        return this.string2Length;
    }

    public int getString1EOBIndex(String delimiter) {
        return this.getString1EOBIndex(delimiter, 0);
    }

    public int getString1EOBIndex(String delimiter, int start) {
        return this.getString1IndexOf(delimiter, start);
    }

    public String getString1BlockAtIndex(int idx) {
        if (idx < 0 || idx >= this.block1Indices.length || this.block1Indices[idx] < 0 || this.block1Indices[idx] >= this.string1Blocks.length) {
            return null;
        }
        return this.string1Blocks[this.block1Indices[idx]];
    }

    public int getString1IndexOf(String str, int start) {
        int toret = this.string1.indexOf(str, start);
        toret = toret == -1 ? this.string1.length() - 1 - start : (toret -= start);
        if (toret < 1) {
            return -1;
        }
        return toret;
    }

    public boolean isPresent1(String patternStr) {
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(this.string1);
        boolean b = m.matches();
        return b;
    }

    public boolean isPresentInString1(String str) {
        return this.string1Present.containsKey((Object)str);
    }

    public char getString1Char(int index) {
        if (--index < 0 || index >= this.string1.length()) {
            return '\u0000';
        }
        return this.string1.charAt(index);
    }

    public int getString2EOBIndex(String delimiter) {
        return this.getString2EOBIndex(delimiter, 0);
    }

    public int getString2EOBIndex(String delimiter, int start) {
        return this.getString2IndexOf(delimiter, start);
    }

    public String getString2BlockAtIndex(int idx) {
        if (idx < 0 || idx >= this.block2Indices.length || this.block2Indices[idx] < 0 || this.block2Indices[idx] >= this.string2Blocks.length) {
            return null;
        }
        return this.string2Blocks[this.block2Indices[idx]];
    }

    public boolean isPresentInString2(String str) {
        return this.string2Present.containsKey((Object)str);
    }

    public int getString2IndexOf(String str, int start) {
        int toret = this.string2.indexOf(str, start);
        toret = toret == -1 ? this.string2.length() - 1 - start : (toret -= start);
        if (toret < 1) {
            return -1;
        }
        return toret;
    }

    public boolean isPresent2(String patternStr) {
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(this.string2);
        boolean b = m.matches();
        return b;
    }

    public char getString2Char(int index) {
        if (--index < 0 || index >= this.string2.length()) {
            return '\u0000';
        }
        return this.string2.charAt(index);
    }

    public boolean isInLexicon(String str) {
        if (this.lexicon == null || str == null) {
            return false;
        }
        return this.lexicon.containsKey((Object)str);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('\n');
        sb.append("String 1: " + this.string1Length + " String 2: " + this.string2Length);
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        int size;
        out.writeInt(0);
        out.writeInt(this.string1Length);
        out.writeInt(this.string2Length);
        out.writeObject(this.string1);
        out.writeObject(this.string2);
        if (this.string1Blocks == null) {
            out.writeInt(-1);
        } else {
            size = this.string1Blocks.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.string1Blocks[i]);
                ++i;
            }
        }
        if (this.string2Blocks == null) {
            out.writeInt(-1);
        } else {
            size = this.string2Blocks.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.string2Blocks[i]);
                ++i;
            }
        }
        out.writeObject(this.string1Present);
        out.writeObject(this.string2Present);
        out.writeObject(this.lexicon);
        if (this.block1Indices == null) {
            out.writeInt(-1);
        } else {
            size = this.block1Indices.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeInt(this.block1Indices[i]);
                ++i;
            }
        }
        if (this.block2Indices == null) {
            out.writeInt(-1);
        } else {
            size = this.block2Indices.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeInt(this.block2Indices[i]);
                ++i;
            }
        }
        out.writeChar(this.delim);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        int i2;
        int version = in.readInt();
        int string1Length = in.readInt();
        int string2Length = in.readInt();
        String string1 = (String)in.readObject();
        String string2 = (String)in.readObject();
        int size = in.readInt();
        if (size == -1) {
            this.string1Blocks = null;
        } else {
            this.string1Blocks = new String[size];
            i2 = 0;
            while (i2 < size) {
                this.string1Blocks[i2] = (String)in.readObject();
                ++i2;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.string2Blocks = null;
        } else {
            this.string2Blocks = new String[size];
            i2 = 0;
            while (i2 < size) {
                this.string2Blocks[i2] = (String)in.readObject();
                ++i2;
            }
        }
        TObjectIntHashMap string1Present = (TObjectIntHashMap)in.readObject();
        TObjectIntHashMap string2Present = (TObjectIntHashMap)in.readObject();
        TObjectIntHashMap lexicon = (TObjectIntHashMap)in.readObject();
        size = in.readInt();
        if (size == -1) {
            this.block1Indices = null;
        } else {
            this.block1Indices = new int[size];
            i = 0;
            while (i < size) {
                this.block1Indices[i] = in.readInt();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.block2Indices = null;
        } else {
            this.block2Indices = new int[size];
            i = 0;
            while (i < size) {
                this.block2Indices[i] = in.readInt();
                ++i;
            }
        }
        this.delim = in.readChar();
    }
}

