/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Labeling;
import cc.mallet.types.RankedFeatureVector;

public class LabelVector
extends RankedFeatureVector
implements Labeling {
    public LabelVector(LabelAlphabet dict, int[] features, double[] values) {
        super((Alphabet)dict, features, values);
    }

    private static int[] indicesForLabels(Label[] labels) {
        int[] indices = new int[labels.length];
        int i = 0;
        while (i < labels.length) {
            indices[i] = labels[i].getIndex();
            ++i;
        }
        return indices;
    }

    public LabelVector(Label[] labels, double[] values) {
        super((Alphabet)labels[0].dictionary, LabelVector.indicesForLabels(labels), values);
    }

    public LabelVector(LabelAlphabet dict, double[] values) {
        super((Alphabet)dict, values);
    }

    @Override
    public final Label labelAtLocation(int loc) {
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.indexAtLocation(loc));
    }

    @Override
    public LabelAlphabet getLabelAlphabet() {
        return (LabelAlphabet)this.dictionary;
    }

    @Override
    public int getBestIndex() {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return this.rankOrder[0];
    }

    @Override
    public Label getBestLabel() {
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.getBestIndex());
    }

    @Override
    public double getBestValue() {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return this.values[this.rankOrder[0]];
    }

    @Override
    public double value(Label label) {
        assert (label.dictionary == this.dictionary);
        return this.values[this.location(label.toString())];
    }

    @Override
    public int getRank(Label label) {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        int ii = -1;
        int tmpIndex = ((LabelAlphabet)this.dictionary).lookupIndex(label.entry);
        ii = 0;
        while (ii < this.rankOrder.length) {
            if (this.rankOrder[ii] == tmpIndex) break;
            ++ii;
        }
        return ii;
    }

    @Override
    public int getRank(int labelIndex) {
        return this.getRank(((LabelAlphabet)this.dictionary).lookupLabel(labelIndex));
    }

    @Override
    public Label getLabelAtRank(int rank) {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.rankOrder[rank]);
    }

    @Override
    public double getValueAtRank(int rank) {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return this.values[this.rankOrder[rank]];
    }

    @Override
    public LabelVector toLabelVector() {
        return this;
    }
}

