/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.RankedFeatureVector;

public class FeatureCounts
extends RankedFeatureVector {
    static boolean countInstances = true;

    private static double[] calcFeatureCounts(InstanceList ilist) {
        int numInstances = ilist.size();
        int numClasses = ilist.getTargetAlphabet().size();
        int numFeatures = ilist.getDataAlphabet().size();
        double[] counts = new double[numFeatures];
        int i = 0;
        while (i < ilist.size()) {
            Instance inst = (Instance)ilist.get(i);
            if (!(inst.getData() instanceof FeatureVector)) {
                throw new IllegalArgumentException("Currently only handles FeatureVector data");
            }
            FeatureVector fv = (FeatureVector)inst.getData();
            if (ilist.getInstanceWeight(i) != 0.0) {
                int j = 0;
                while (j < fv.numLocations()) {
                    if (countInstances) {
                        int n = fv.indexAtLocation(j);
                        counts[n] = counts[n] + 1.0;
                    } else {
                        int n = fv.indexAtLocation(j);
                        counts[n] = counts[n] + fv.valueAtLocation(j);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return counts;
    }

    public FeatureCounts(InstanceList ilist) {
        super(ilist.getDataAlphabet(), FeatureCounts.calcFeatureCounts(ilist));
    }

    public FeatureCounts(Alphabet vocab, double[] counts) {
        super(vocab, counts);
    }

    public static class Factory
    implements RankedFeatureVector.Factory {
        @Override
        public RankedFeatureVector newRankedFeatureVector(InstanceList ilist) {
            return new FeatureCounts(ilist);
        }
    }
}

