/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import java.util.Collection;

public interface Optimizable {
    public int getNumParameters();

    public void getParameters(double[] var1);

    public double getParameter(int var1);

    public void setParameters(double[] var1);

    public void setParameter(int var1, double var2);

    public static interface ByBatchGradient
    extends Optimizable {
        public void getBatchValueGradient(double[] var1, int var2, int[] var3);

        public double getBatchValue(int var1, int[] var2);
    }

    public static interface ByCombiningBatchGradient
    extends Optimizable {
        public void getBatchValueGradient(double[] var1, int var2, int[] var3);

        public double getBatchValue(int var1, int[] var2);

        public void combineGradients(Collection<double[]> var1, double[] var2);

        public int getNumBatches();
    }

    public static interface ByGISUpdate
    extends Optimizable {
        public double getValue();

        public void getGISUpdate(double[] var1);
    }

    public static interface ByGradient
    extends Optimizable {
        public void getValueGradient(double[] var1);
    }

    public static interface ByGradientValue
    extends Optimizable {
        public void getValueGradient(double[] var1);

        public double getValue();
    }

    public static interface ByHessian
    extends ByGradientValue {
        public void getValueHessian(double[][] var1);
    }

    public static interface ByValue
    extends Optimizable {
        public double getValue();
    }

    public static interface ByVotedPerceptron
    extends Optimizable {
        public int getNumInstances();

        public void getValueGradientForInstance(int var1, double[] var2);
    }
}

