/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.BackTrackLineSearch;
import cc.mallet.optimize.LineOptimizer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.optimize.OptimizerEvaluator;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class GradientAscent
implements Optimizer {
    private static Logger logger = MalletLogger.getLogger(GradientAscent.class.getName());
    boolean converged = false;
    Optimizable.ByGradientValue optimizable;
    private double maxStep = 1.0;
    private OptimizerEvaluator.ByGradient eval;
    static final double initialStepSize = 0.2;
    double tolerance = 0.001;
    int maxIterations = 200;
    LineOptimizer.ByGradient lineMaximizer;
    double stpmax = 100.0;
    final double eps = 1.0E-10;
    double step = 0.2;

    public GradientAscent(Optimizable.ByGradientValue function) {
        this.optimizable = function;
        this.lineMaximizer = new BackTrackLineSearch(function);
    }

    @Override
    public Optimizable getOptimizable() {
        return this.optimizable;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    public LineOptimizer.ByGradient getLineMaximizer() {
        return this.lineMaximizer;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getInitialStepSize() {
        return 0.2;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.step = initialStepSize;
    }

    public double getStpmax() {
        return this.stpmax;
    }

    public void setStpmax(double stpmax) {
        this.stpmax = stpmax;
    }

    @Override
    public boolean optimize() {
        return this.optimize(this.maxIterations);
    }

    @Override
    public boolean optimize(int numIterations) {
        double fp = this.optimizable.getValue();
        double[] xi = new double[this.optimizable.getNumParameters()];
        this.optimizable.getValueGradient(xi);
        int iterations = 0;
        while (iterations < numIterations) {
            logger.info("At iteration " + iterations + ", cost = " + fp + ", scaled = " + this.maxStep + " step = " + this.step + ", gradient infty-norm = " + MatrixOps.infinityNorm(xi));
            double sum = MatrixOps.twoNorm(xi);
            if (sum > this.stpmax) {
                logger.info("*** Step 2-norm " + sum + " greater than max " + this.stpmax + "  Scaling...");
                MatrixOps.timesEquals(xi, this.stpmax / sum);
            }
            this.step = this.lineMaximizer.optimize(xi, this.step);
            double fret = this.optimizable.getValue();
            if (2.0 * Math.abs(fret - fp) <= this.tolerance * (Math.abs(fret) + Math.abs(fp) + 1.0E-10)) {
                logger.info("Gradient Ascent: Value difference " + Math.abs(fret - fp) + " below " + "tolerance; saying converged.");
                this.converged = true;
                return true;
            }
            fp = fret;
            this.optimizable.getValueGradient(xi);
            if (this.eval != null) {
                this.eval.evaluate(this.optimizable, iterations);
            }
            ++iterations;
        }
        return false;
    }

    public void setMaxStepSize(double v) {
        this.maxStep = v;
    }

    public void setEvaluator(OptimizerEvaluator.ByGradient eval) {
        this.eval = eval;
    }
}

