/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.util;

import bsh.EvalError;
import bsh.Interpreter;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.BetaFactor;
import cc.mallet.grmm.types.BinaryUnaryFactor;
import cc.mallet.grmm.types.BoltzmannPairFactor;
import cc.mallet.grmm.types.BoltzmannUnaryFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.PottsTableFactor;
import cc.mallet.grmm.types.UniNormalFactor;
import cc.mallet.grmm.types.UniformFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ModelReader {
    private static THashMap allClasses = new THashMap();
    private THashMap name2var = new THashMap();
    private static Pattern nbrRegex;

    static {
        allClasses.put((Object)"potts", PottsTableFactor.class);
        allClasses.put((Object)"unary", BoltzmannUnaryFactor.class);
        allClasses.put((Object)"binaryunary", BinaryUnaryFactor.class);
        allClasses.put((Object)"binarypair", BoltzmannPairFactor.class);
        allClasses.put((Object)"uniform", UniformFactor.class);
        allClasses.put((Object)"normal", UniNormalFactor.class);
        allClasses.put((Object)"beta", BetaFactor.class);
        nbrRegex = Pattern.compile("[+-]?\\d+(?:\\.\\d+)?(E[+-]\\d+)?");
    }

    public static Assignment readFromMatrix(VarSet vars, Reader in) throws IOException {
        String line;
        Variable[] varr = vars.toVariableArray();
        Interpreter interpreter = new Interpreter();
        BufferedReader bIn = new BufferedReader(in);
        Assignment assn = new Assignment();
        while ((line = bIn.readLine()) != null) {
            String[] fields = line.split("\\s+");
            Object[] vals = new Object[fields.length];
            int i = 0;
            while (i < fields.length) {
                try {
                    vals[i] = interpreter.eval(fields[i]);
                }
                catch (EvalError e) {
                    throw new RuntimeException("Error reading line: " + line, e);
                }
                ++i;
            }
            assn.addRow(varr, vals);
        }
        return assn;
    }

    public FactorGraph readModel(BufferedReader in) throws IOException {
        String line;
        ArrayList<Factor> factors = new ArrayList<Factor>();
        while ((line = in.readLine()) != null) {
            try {
                if (Pattern.matches("^\\s*$", line)) continue;
                String[] fields = line.split("\\s+");
                if (fields[0].equalsIgnoreCase("VAR")) {
                    this.handleVariableDecl(fields);
                    continue;
                }
                Factor factor = this.factorFromLine(fields);
                factors.add(factor);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading line:\n" + line, e);
            }
        }
        FactorGraph fg = new FactorGraph();
        for (Factor factor : factors) {
            fg.multiplyBy(factor);
        }
        return fg;
    }

    private void handleVariableDecl(String[] fields) {
        int colonIdx = this.findColon(fields);
        if (fields.length != colonIdx + 2) {
            throw new IllegalArgumentException("Invalid syntax");
        }
        String numOutsString = fields[colonIdx + 1];
        int numOutcomes = numOutsString.equalsIgnoreCase("continuous") ? -1 : Integer.parseInt(numOutsString);
        int i = 0;
        while (i < colonIdx) {
            String name = fields[i];
            Variable var = new Variable(numOutcomes);
            var.setLabel(name);
            this.name2var.put((Object)name, (Object)var);
            ++i;
        }
    }

    private int findColon(String[] fields) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].equals(":")) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Invalid syntax.");
    }

    private Factor factorFromLine(String[] fields) {
        int idx = this.findTwiddle(fields);
        return this.constructFactor(fields, idx);
    }

    private int findTwiddle(String[] fields) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].equals("~")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Factor constructFactor(String[] fields, int idx) {
        Factor factor;
        Class factorClass = this.determineFactorClass(fields, idx);
        Object[] args = this.determineFactorArgs(fields, idx);
        Constructor factorCtor = this.findCtor(factorClass, args);
        try {
            factor = (Factor)factorCtor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return factor;
    }

    /*
     * Unable to fully structure code
     */
    private Constructor findCtor(Class factorClass, Object[] args) {
        argClass = new Class[args.length];
        i = 0;
        while (i < args.length) {
            argClass[i] = args[i].getClass();
            if (argClass[i] == Double.class) {
                argClass[i] = Double.TYPE;
            }
            ++i;
        }
        try {
            return factorClass.getDeclaredConstructor(argClass);
        }
        catch (NoSuchMethodException e) {
            buf = new StringBuffer("Invalid argments for factor " + factorClass + "\n");
            buf.append("Args were:\n");
            i = 0;
            ** while (i < args.length)
        }
lbl-1000:
        // 1 sources

        {
            buf.append(args[i]);
            buf.append(" ");
            ++i;
            continue;
        }
lbl23:
        // 1 sources

        buf.append("\n");
        i = 0;
        while (i < args.length) {
            buf.append(args[i].getClass());
            buf.append(" ");
            ++i;
        }
        buf.append("\n");
        throw new RuntimeException(buf.toString());
    }

    private Class determineFactorClass(String[] fields, int twiddleIdx) {
        String factorName = fields[twiddleIdx + 1].toLowerCase();
        Class theClass = (Class)allClasses.get((Object)factorName);
        if (theClass != null) {
            return theClass;
        }
        throw new RuntimeException("Could not determine factor class from " + factorName);
    }

    private Object[] determineFactorArgs(String[] fields, int twiddleIdx) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length);
        int i = 0;
        while (i < twiddleIdx) {
            args.add(this.varFromName(fields[i], true));
            ++i;
        }
        i = twiddleIdx + 2;
        while (i < fields.length) {
            args.add(this.varFromName(fields[i], false));
            ++i;
        }
        return args.toArray();
    }

    private Object varFromName(String name, boolean preTwiddle) {
        if (nbrRegex.matcher(name).matches()) {
            return new Double(Double.parseDouble(name));
        }
        if (this.name2var.contains((Object)name)) {
            return this.name2var.get((Object)name);
        }
        Variable var = preTwiddle ? new Variable(2) : new Variable(-1);
        var.setLabel(name);
        this.name2var.put((Object)name, (Object)var);
        return var;
    }
}

