/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.Segment;
import cc.mallet.fst.confidence.InstanceWithConfidence;
import cc.mallet.fst.confidence.PipedInstanceWithConfidence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Sequence;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class ConfidenceEvaluator {
    static int DEFAULT_NUM_BINS = 20;
    Vector confidences;
    int nBins;
    int numCorrect;

    public ConfidenceEvaluator(Vector confidences, int nBins) {
        this.confidences = confidences;
        this.nBins = nBins;
        this.numCorrect = this.getNumCorrectEntities();
        Collections.sort(confidences, new ConfidenceComparator());
    }

    public ConfidenceEvaluator(Vector confidences) {
        this(confidences, DEFAULT_NUM_BINS);
    }

    public ConfidenceEvaluator(Segment[] segments, boolean sorted) {
        this.confidences = new Vector();
        int i = 0;
        while (i < segments.length) {
            this.confidences.add(new EntityConfidence(segments[i].getConfidence(), segments[i].correct(), segments[i].getInput(), segments[i].getStart(), segments[i].getEnd()));
            ++i;
        }
        if (!sorted) {
            Collections.sort(this.confidences, new ConfidenceComparator());
        }
        this.nBins = DEFAULT_NUM_BINS;
        this.numCorrect = this.getNumCorrectEntities();
    }

    public ConfidenceEvaluator(InstanceWithConfidence[] instances, boolean sorted) {
        this.confidences = new Vector();
        int i = 0;
        while (i < instances.length) {
            Sequence input = (Sequence)instances[i].getInstance().getData();
            this.confidences.add(new EntityConfidence(instances[i].getConfidence(), instances[i].correct(), input, 0, input.size() - 1));
            ++i;
        }
        if (!sorted) {
            Collections.sort(this.confidences, new ConfidenceComparator());
        }
        this.nBins = DEFAULT_NUM_BINS;
        this.numCorrect = this.getNumCorrectEntities();
    }

    public ConfidenceEvaluator(PipedInstanceWithConfidence[] instances, boolean sorted) {
        this.confidences = new Vector();
        int i = 0;
        while (i < instances.length) {
            this.confidences.add(new EntityConfidence(instances[i].getConfidence(), instances[i].correct(), null, 0, 1));
            ++i;
        }
        if (!sorted) {
            Collections.sort(this.confidences, new ConfidenceComparator());
        }
        this.nBins = DEFAULT_NUM_BINS;
        this.numCorrect = this.getNumCorrectEntities();
    }

    public double pointBiserialCorrelation() {
        double x0bar = this.getAverageIncorrectConfidence();
        double x1bar = this.getAverageCorrectConfidence();
        double p = (double)this.numCorrect / (double)this.size();
        double sx = this.getConfidenceStandardDeviation();
        return (x1bar - x0bar) * Math.sqrt(p * (1.0 - p)) / sx;
    }

    public double getAveragePrecision() {
        int nc = 0;
        int ni = 0;
        double totalPrecision = 0.0;
        int i = this.confidences.size() - 1;
        while (i >= 0) {
            EntityConfidence c = (EntityConfidence)this.confidences.get(i);
            if (c.correct()) {
                totalPrecision += (double)(++nc) / (double)(nc + ni);
            } else {
                ++ni;
            }
            --i;
        }
        return totalPrecision / (double)nc;
    }

    public double getWorstAveragePrecision() {
        int ni = this.confidences.size() - this.numCorrect;
        double totalPrecision = 0.0;
        int nc = 1;
        while (nc <= this.numCorrect) {
            totalPrecision += (double)nc / (double)(nc + ni);
            ++nc;
        }
        return totalPrecision / (double)this.numCorrect;
    }

    public double getConfidenceSum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.size()) {
            sum += ((EntityConfidence)this.confidences.get(i)).confidence();
            ++i;
        }
        return sum;
    }

    public double getConfidenceMean() {
        return this.getConfidenceSum() / (double)this.size();
    }

    public double getConfidenceStandardDeviation() {
        double mean = this.getConfidenceMean();
        double sumSquaredDifference = 0.0;
        int i = 0;
        while (i < this.size()) {
            double conf = ((EntityConfidence)this.confidences.get(i)).confidence();
            sumSquaredDifference += (conf - mean) * (conf - mean);
            ++i;
        }
        return Math.sqrt(sumSquaredDifference / (double)this.size());
    }

    public double correlation() {
        double xSum = 0.0;
        double xSumOfSquares = 0.0;
        double ySum = 0.0;
        double ySumOfSquares = 0.0;
        double xySum = 0.0;
        int i = 0;
        while (i < this.size()) {
            double value = ((EntityConfidence)this.confidences.get(i)).correct() ? 1.0 : -1.0;
            xSum += value;
            xSumOfSquares += value * value;
            double conf = ((EntityConfidence)this.confidences.get(i)).confidence();
            ySum += conf;
            ySumOfSquares += conf * conf;
            xySum += value * conf;
            ++i;
        }
        double xVariance = xSumOfSquares - xSum * xSum / (double)this.size();
        double yVariance = ySumOfSquares - ySum * ySum / (double)this.size();
        double crossVariance = xySum - xSum * ySum / (double)this.size();
        return crossVariance / Math.sqrt(xVariance * yVariance);
    }

    public double[] getAccuracyCoverageValues() {
        double[] values = new double[this.nBins];
        int step = 100 / this.nBins;
        int i = 0;
        while (i < values.length) {
            values[i] = this.accuracyAtCoverage((double)step * (double)(i + 1) / 100.0);
            ++i;
        }
        return values;
    }

    public String accuracyCoverageValuesToString() {
        String buf = "";
        double[] vals = this.getAccuracyCoverageValues();
        int step = 100 / this.nBins;
        int i = 0;
        while (i < vals.length) {
            buf = String.valueOf(buf) + (double)step * (double)(i + 1) / 100.0 + "\t" + vals[i] + "\n";
            ++i;
        }
        return buf;
    }

    public double[][] getAccuracyRecallValues(int totalTrue) {
        double[][] values = new double[this.nBins][2];
        int step = 100 / this.nBins;
        int i = 0;
        while (i < this.nBins) {
            values[i] = new double[2];
            double coverage = (double)step * (double)(i + 1) / 100.0;
            values[i][1] = this.accuracyAtCoverage(coverage);
            int numCorrect = this.numCorrectAtCoverage(coverage);
            values[i][0] = (double)numCorrect / (double)totalTrue;
            ++i;
        }
        return values;
    }

    public String accuracyRecallValuesToString(int totalTrue) {
        String buf = "";
        double[][] vals = this.getAccuracyRecallValues(totalTrue);
        int i = 0;
        while (i < this.nBins) {
            buf = String.valueOf(buf) + vals[i][0] + "\t" + vals[i][1] + "\n";
            ++i;
        }
        return buf;
    }

    public double accuracyAtCoverage(double cov) {
        assert (cov <= 1.0 && cov > 0.0);
        int numPoints = (int)Math.round((double)this.size() * cov);
        return (double)this.numCorrectAtCoverage(cov) / (double)numPoints;
    }

    public int numCorrectAtCoverage(double cov) {
        assert (cov <= 1.0 && cov > 0.0);
        int numPoints = (int)Math.round((double)this.size() * cov);
        int numCorrect = 0;
        int i = 0;
        while (i < numPoints) {
            if (((EntityConfidence)this.confidences.get(this.size() - i - 1)).correct()) {
                ++numCorrect;
            }
            ++i;
        }
        return numCorrect;
    }

    public double getAverageAccuracy() {
        int numCorrect = 0;
        double totalArea = 0.0;
        int i = this.confidences.size() - 1;
        while (i >= 0) {
            if (((EntityConfidence)this.confidences.get(i)).correct()) {
                ++numCorrect;
            }
            totalArea += (double)numCorrect / (double)(this.confidences.size() - i);
            --i;
        }
        return totalArea / (double)this.confidences.size();
    }

    public int numCorrect() {
        return this.numCorrect;
    }

    private int getNumCorrectEntities() {
        int sum = 0;
        int i = 0;
        while (i < this.confidences.size()) {
            EntityConfidence ec = (EntityConfidence)this.confidences.get(i);
            if (ec.correct()) {
                ++sum;
            }
            ++i;
        }
        return sum;
    }

    public double getAverageIncorrectConfidence() {
        double sum = 0.0;
        int i = 0;
        while (i < this.confidences.size()) {
            EntityConfidence ec = (EntityConfidence)this.confidences.get(i);
            if (!ec.correct()) {
                sum += ec.confidence();
            }
            ++i;
        }
        return sum / ((double)this.size() - (double)this.numCorrect);
    }

    public double getAverageCorrectConfidence() {
        double sum = 0.0;
        int i = 0;
        while (i < this.confidences.size()) {
            EntityConfidence ec = (EntityConfidence)this.confidences.get(i);
            if (ec.correct()) {
                sum += ec.confidence();
            }
            ++i;
        }
        return sum / (double)this.numCorrect;
    }

    public int size() {
        return this.confidences.size();
    }

    public String toString() {
        StringBuffer toReturn = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            toReturn.append(String.valueOf(((EntityConfidence)this.confidences.get(i)).toString()) + " ");
            ++i;
        }
        return toReturn.toString();
    }

    private class ConfidenceComparator
    implements Comparator {
        private ConfidenceComparator() {
        }

        public final int compare(Object a, Object b) {
            double x = ((EntityConfidence)a).confidence();
            double y = ((EntityConfidence)b).confidence();
            double difference = x - y;
            int toReturn = 0;
            if (difference > 0.0) {
                toReturn = 1;
            } else if (difference < 0.0) {
                toReturn = -1;
            }
            return toReturn;
        }
    }

    public static class EntityConfidence {
        double confidence;
        boolean correct;
        String entity;

        public EntityConfidence(double conf, boolean corr, String text) {
            this.confidence = conf;
            this.correct = corr;
            this.entity = text;
        }

        public EntityConfidence(double conf, boolean corr, Sequence input, int start, int end) {
            this.confidence = conf;
            this.correct = corr;
            StringBuffer buff = new StringBuffer();
            if (input != null) {
                int j = start;
                while (j <= end) {
                    FeatureVector fv = (FeatureVector)input.get(j);
                    int k = 0;
                    while (k < fv.numLocations()) {
                        String featureName = fv.getAlphabet().lookupObject(fv.indexAtLocation(k)).toString();
                        if (featureName.startsWith("W=") && featureName.indexOf("@") == -1) {
                            buff.append(String.valueOf(featureName.substring(featureName.indexOf(61) + 1)) + " ");
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            this.entity = buff.toString();
        }

        public double confidence() {
            return this.confidence;
        }

        public boolean correct() {
            return this.correct;
        }

        public String toString() {
            StringBuffer toReturn = new StringBuffer();
            toReturn.append(String.valueOf(this.entity) + " / " + this.confidence + " / " + (this.correct ? "correct" : "incorrect") + "\n");
            return toReturn.toString();
        }
    }
}

