/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster;

import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class Clustering
implements Serializable {
    protected int numLabels;
    protected int[] labels;
    protected InstanceList instances;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public Clustering(InstanceList instances, int numLabels, int[] labels) {
        if (instances.size() != labels.length) {
            throw new IllegalArgumentException("Instance list length does not match cluster labeling");
        }
        if (numLabels < 1) {
            throw new IllegalArgumentException("Number of labels must be strictly positive.");
        }
        int i = 0;
        while (i < labels.length) {
            if (labels[i] < 0 || labels[i] >= numLabels) {
                throw new IllegalArgumentException("Label mapping must have range [0,numLabels).");
            }
            ++i;
        }
        this.instances = instances;
        this.numLabels = numLabels;
        this.labels = labels;
    }

    public InstanceList getInstances() {
        return this.instances;
    }

    public InstanceList getCluster(int label) {
        InstanceList cluster = new InstanceList(this.instances.getPipe());
        int n = 0;
        while (n < this.instances.size()) {
            if (this.labels[n] == label) {
                cluster.add((Instance)this.instances.get(n));
            }
            ++n;
        }
        return cluster;
    }

    public InstanceList[] getClusters() {
        InstanceList[] clusters = new InstanceList[this.numLabels];
        int c = 0;
        while (c < this.numLabels) {
            clusters[c] = this.getCluster(c);
            ++c;
        }
        return clusters;
    }

    public int getLabel(int index) {
        return this.labels[index];
    }

    public int[] getLabels() {
        return this.labels;
    }

    public int getNumClusters() {
        return this.numLabels;
    }

    public int getNumInstances() {
        return this.instances.size();
    }

    public int size(int label) {
        int size = 0;
        int i = 0;
        while (i < this.labels.length) {
            if (this.labels[i] == label) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public int[] getIndicesWithLabel(int label) {
        int[] indices = new int[this.size(label)];
        int count = 0;
        int i = 0;
        while (i < this.labels.length) {
            if (this.labels[i] == label) {
                indices[count++] = i;
            }
            ++i;
        }
        return indices;
    }

    public boolean equals(Object o) {
        Clustering c = (Clustering)o;
        return Arrays.equals(c.getLabels(), this.labels);
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "#Clusters: " + this.getNumClusters() + "\n";
        int i = 0;
        while (i < this.getNumClusters()) {
            result = String.valueOf(result) + "\n--CLUSTER " + i + "--";
            int[] cluster = this.getIndicesWithLabel(i);
            int k = 0;
            while (k < cluster.length) {
                result = String.valueOf(result) + "\n\t" + ((Instance)this.instances.get(cluster[k])).getData().toString();
                ++k;
            }
            ++i;
        }
        return result;
    }

    public Clustering shallowCopy() {
        int[] newLabels = new int[this.labels.length];
        System.arraycopy(this.labels, 0, newLabels, 0, this.labels.length);
        Clustering c = new Clustering(this.instances, this.numLabels, newLabels);
        return c;
    }

    public void setLabel(int index, int label) {
        this.labels[index] = label;
    }

    public void setNumLabels(int n) {
        this.numLabels = n;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

