/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.FeatureCountTool;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

public class Vectors2Info {
    private static Logger logger = MalletLogger.getLogger(Vectors2Info.class.getName());
    static CommandOption.File inputFile = new CommandOption.File(Vectors2Info.class, "input", "FILE", true, new File("-"), "Read the instance list from this file; Using - indicates stdin.", null);
    static CommandOption.Boolean printInstances = new CommandOption.Boolean(Vectors2Info.class, "print-instances", "N", false, false, "Print labels and contents for all instances.", null);
    static CommandOption.Integer printInfogain = new CommandOption.Integer(Vectors2Info.class, "print-infogain", "N", false, 0, "Print top N words by information gain, sorted.", null);
    static CommandOption.Boolean printLabels = new CommandOption.Boolean(Vectors2Info.class, "print-labels", "[TRUE|FALSE]", false, false, "Print class labels known to instance list, one per line.", null);
    static CommandOption.Boolean printFeatures = new CommandOption.Boolean(Vectors2Info.class, "print-features", "[TRUE|FALSE]", false, false, "Print the data alphabet, one feature per line.", null);
    static CommandOption.Boolean printFeatureCounts = new CommandOption.Boolean(Vectors2Info.class, "print-feature-counts", "[TRUE|FALSE]", false, false, "Print feature names, feature counts (ie term frequency), and feature index counts (ie document frequency).", null);
    static CommandOption.String printMatrix = new CommandOption.String(Vectors2Info.class, "print-matrix", "STRING", false, "sic", "Print word/document matrix in the specified format (a|s)(b|i)(n|w|c|e), for (all vs. sparse), (binary vs. integer), (number vs. word vs. combined vs. empty)", null){

        @Override
        public void parseArg(String arg) {
            if (arg == null) {
                arg = this.defaultValue;
            }
            char c0 = arg.charAt(0);
            char c1 = arg.charAt(1);
            char c2 = arg.charAt(2);
            if (arg.length() != 3 || c0 != 's' && c0 != 'a' || c1 != 'b' && c1 != 'i' || c2 != 'n' && c2 != 'w' && c2 != 'c' && c2 != 'e') {
                throw new IllegalArgumentException("Illegal argument = " + arg + " in --print-matrix=" + arg);
            }
            this.value = arg;
        }
    };

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CommandOption.setSummary(Vectors2Info.class, "A tool for printing information about instance lists of feature vectors.");
        CommandOption.process(Vectors2Info.class, args);
        if (args.length == 0) {
            CommandOption.getList(Vectors2Info.class).printUsage(false);
            System.exit(-1);
        }
        InstanceList instances = InstanceList.load(Vectors2Info.inputFile.value);
        if (Vectors2Info.printLabels.value) {
            Alphabet labelAlphabet = instances.getTargetAlphabet();
            int i = 0;
            while (i < labelAlphabet.size()) {
                System.out.println(labelAlphabet.lookupObject(i));
                ++i;
            }
            System.out.print("\n");
        }
        if (Vectors2Info.printInstances.value) {
            for (Instance instance : instances) {
                System.out.println(instance.getName() + "\t" + instance.getTarget() + "\t" + instance.getData());
            }
        }
        if (Vectors2Info.printFeatureCounts.value) {
            FeatureCountTool counter = new FeatureCountTool(instances);
            counter.count();
            counter.printCounts();
        }
        if (Vectors2Info.printFeatures.value) {
            Alphabet alphabet = instances.getDataAlphabet();
            int i = 0;
            while (i < alphabet.size()) {
                System.out.println(alphabet.lookupObject(i));
                ++i;
            }
        }
        if (Vectors2Info.printInfogain.value > 0) {
            InfoGain ig = new InfoGain(instances);
            int i = 0;
            while (i < Vectors2Info.printInfogain.value) {
                System.out.println(i + " " + ig.getObjectAtRank(i));
                ++i;
            }
            System.out.print("\n");
        }
        if (printMatrix.wasInvoked()) {
            Vectors2Info.printInstanceList(instances, Vectors2Info.printMatrix.value);
        }
    }

    private static void printInstanceList(InstanceList instances, String formatString) {
        int numInstances = instances.size();
        int numClasses = instances.getTargetAlphabet().size();
        int numFeatures = instances.getDataAlphabet().size();
        Alphabet dataAlphabet = instances.getDataAlphabet();
        double[] counts = new double[numFeatures];
        int i = 0;
        while (i < instances.size()) {
            Instance instance = (Instance)instances.get(i);
            if (instance.getData() instanceof FeatureVector) {
                FeatureVector fv = (FeatureVector)instance.getData();
                System.out.print(instance.getName() + " " + instance.getTarget());
                if (formatString.charAt(0) == 'a') {
                    int fvi = 0;
                    while (fvi < numFeatures) {
                        Vectors2Info.printFeature(dataAlphabet.lookupObject(fvi), fvi, fv.value(fvi), formatString);
                        ++fvi;
                    }
                } else {
                    int l = 0;
                    while (l < fv.numLocations()) {
                        int fvi = fv.indexAtLocation(l);
                        Vectors2Info.printFeature(dataAlphabet.lookupObject(fvi), fvi, fv.valueAtLocation(l), formatString);
                        ++l;
                    }
                }
            } else if (instance.getData() instanceof FeatureSequence) {
                FeatureSequence featureSequence = (FeatureSequence)instance.getData();
                StringBuilder output = new StringBuilder();
                output.append(instance.getName() + " " + instance.getTarget());
                int position = 0;
                while (position < featureSequence.size()) {
                    int featureIndex = featureSequence.getIndexAtPosition(position);
                    char featureFormat = formatString.charAt(2);
                    if (featureFormat == 'w') {
                        output.append(" " + dataAlphabet.lookupObject(featureIndex));
                    } else if (featureFormat == 'n') {
                        output.append(" " + featureIndex);
                    } else if (featureFormat == 'c') {
                        output.append(" " + dataAlphabet.lookupObject(featureIndex) + ":" + featureIndex);
                    }
                    ++position;
                }
                System.out.println(output);
            } else {
                throw new IllegalArgumentException("Printing is supported for FeatureVector and FeatureSequence data, found " + instance.getData().getClass());
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    private static void printFeature(Object o, int fvi, double featureValue, String formatString) {
        char c1 = formatString.charAt(2);
        if (c1 == 'w') {
            System.out.print("  " + o);
        } else if (c1 == 'n') {
            System.out.print("  " + fvi);
        } else if (c1 == 'c') {
            System.out.print("  " + o + ":" + fvi);
        }
        char c2 = formatString.charAt(1);
        if (c2 == 'i') {
            System.out.print(" " + (int)(featureValue + 0.5));
        } else if (c2 == 'b') {
            System.out.print(" " + (featureValue > 0.5 ? "1" : "0"));
        }
    }
}

