/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.ge;

import cc.mallet.classify.constraints.ge.MaxEntGEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class MaxEntRangeL2FLGEConstraints
implements MaxEntGEConstraint {
    private boolean useValues;
    private boolean normalize;
    private int numFeatures;
    private int numLabels;
    protected TIntObjectHashMap<MaxEntL2IndGEConstraint> constraints;
    protected TIntArrayList indexCache;
    protected TDoubleArrayList valueCache;

    public MaxEntRangeL2FLGEConstraints(int numFeatures, int numLabels, boolean useValues, boolean normalize) {
        this.numFeatures = numFeatures;
        this.numLabels = numLabels;
        this.useValues = useValues;
        this.normalize = normalize;
        this.constraints = new TIntObjectHashMap();
        this.indexCache = new TIntArrayList();
        this.valueCache = new TDoubleArrayList();
    }

    public void addConstraint(int fi, int li, double lower, double upper, double weight) {
        if (!this.constraints.containsKey(fi)) {
            this.constraints.put(fi, (Object)new MaxEntL2IndGEConstraint());
        }
        ((MaxEntL2IndGEConstraint)this.constraints.get(fi)).add(li, lower, upper, weight);
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        int ii = 0;
        BitSet bitSet = new BitSet(data.size());
        for (Instance instance : data) {
            double weight = data.getInstanceWeight(instance);
            FeatureVector fv = (FeatureVector)instance.getData();
            int loc = 0;
            while (loc < fv.numLocations()) {
                int fi = fv.indexAtLocation(loc);
                if (this.constraints.containsKey(fi)) {
                    ((MaxEntL2IndGEConstraint)this.constraints.get((int)fi)).count = this.useValues ? (((MaxEntL2IndGEConstraint)this.constraints.get((int)fi)).count += weight * fv.valueAtLocation(loc)) : (((MaxEntL2IndGEConstraint)this.constraints.get((int)fi)).count += weight);
                    bitSet.set(ii);
                }
                ++loc;
            }
            ++ii;
            if (!this.constraints.containsKey(this.numFeatures)) continue;
            bitSet.set(ii);
            ((MaxEntL2IndGEConstraint)this.constraints.get((int)this.numFeatures)).count += weight;
        }
        return bitSet;
    }

    @Override
    public void preProcess(FeatureVector input) {
        this.indexCache.resetQuick();
        if (this.useValues) {
            this.valueCache.resetQuick();
        }
        int loc = 0;
        while (loc < input.numLocations()) {
            int fi = input.indexAtLocation(loc);
            if (this.constraints.containsKey(fi)) {
                this.indexCache.add(fi);
                if (this.useValues) {
                    this.valueCache.add(input.valueAtLocation(loc));
                }
            }
            ++loc;
        }
        if (this.constraints.containsKey(this.numFeatures)) {
            this.indexCache.add(this.numFeatures);
            if (this.useValues) {
                this.valueCache.add(1.0);
            }
        }
    }

    @Override
    public double getCompositeConstraintFeatureValue(FeatureVector input, int label) {
        double value = 0.0;
        int i = 0;
        while (i < this.indexCache.size()) {
            value = this.useValues ? (value += ((MaxEntL2IndGEConstraint)this.constraints.get(this.indexCache.getQuick(i))).getGradientContribution(label) * this.valueCache.getQuick(i)) : (value += ((MaxEntL2IndGEConstraint)this.constraints.get(this.indexCache.getQuick(i))).getGradientContribution(label));
            ++i;
        }
        return value;
    }

    @Override
    public void computeExpectations(FeatureVector input, double[] dist, double weight) {
        this.preProcess(input);
        int li = 0;
        while (li < this.numLabels) {
            double p = weight * dist[li];
            int i = 0;
            while (i < this.indexCache.size()) {
                if (this.useValues) {
                    int n = li;
                    ((MaxEntL2IndGEConstraint)this.constraints.get((int)this.indexCache.getQuick((int)i))).expectation[n] = ((MaxEntL2IndGEConstraint)this.constraints.get((int)this.indexCache.getQuick((int)i))).expectation[n] + p * this.valueCache.getQuick(i);
                } else {
                    int n = li;
                    ((MaxEntL2IndGEConstraint)this.constraints.get((int)this.indexCache.getQuick((int)i))).expectation[n] = ((MaxEntL2IndGEConstraint)this.constraints.get((int)this.indexCache.getQuick((int)i))).expectation[n] + p;
                }
                ++i;
            }
            ++li;
        }
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            MaxEntL2IndGEConstraint constraint = (MaxEntL2IndGEConstraint)this.constraints.get(fi);
            if (constraint.count > 0.0) {
                int labelIndex = 0;
                while (labelIndex < this.numLabels) {
                    value -= constraint.getValue(labelIndex);
                    ++labelIndex;
                }
            }
            ++n2;
        }
        assert (!Double.isNaN(value) && !Double.isInfinite(value));
        return value;
    }

    @Override
    public void zeroExpectations() {
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            ((MaxEntL2IndGEConstraint)this.constraints.get((int)fi)).expectation = new double[((MaxEntL2IndGEConstraint)this.constraints.get(fi)).getNumConstrainedLabels()];
            ++n2;
        }
    }

    protected class MaxEntL2IndGEConstraint {
        protected int index = 0;
        protected double count = 0.0;
        protected ArrayList<Double> lower = new ArrayList();
        protected ArrayList<Double> upper = new ArrayList();
        protected ArrayList<Double> weights = new ArrayList();
        protected HashMap<Integer, Integer> labelMap = new HashMap();
        protected double[] expectation;

        public void add(int label, double lower, double upper, double weight) {
            this.lower.add(lower);
            this.upper.add(upper);
            this.weights.add(weight);
            this.labelMap.put(label, this.index);
            ++this.index;
        }

        public void incrementExpectation(int li, double value) {
            if (this.labelMap.containsKey(li)) {
                int i;
                int n = i = this.labelMap.get(li).intValue();
                this.expectation[n] = this.expectation[n] + value;
            }
        }

        public double getValue(int li) {
            if (this.labelMap.containsKey(li)) {
                int i = this.labelMap.get(li);
                assert (this.count != 0.0);
                double ex = MaxEntRangeL2FLGEConstraints.this.normalize ? this.expectation[i] / this.count : this.expectation[i];
                if (ex < this.lower.get(i)) {
                    return this.weights.get(i) * Math.pow(this.lower.get(i) - ex, 2.0);
                }
                if (ex > this.upper.get(i)) {
                    return this.weights.get(i) * Math.pow(this.upper.get(i) - ex, 2.0);
                }
            }
            return 0.0;
        }

        public int getNumConstrainedLabels() {
            return this.index;
        }

        public double getGradientContribution(int li) {
            if (this.labelMap.containsKey(li)) {
                int i = this.labelMap.get(li);
                assert (this.count != 0.0);
                if (MaxEntRangeL2FLGEConstraints.this.normalize) {
                    double ex = this.expectation[i] / this.count;
                    if (ex < this.lower.get(i)) {
                        return 2.0 * this.weights.get(i) * (this.lower.get(i) / this.count - this.expectation[i] / (this.count * this.count));
                    }
                    if (ex > this.upper.get(i)) {
                        return 2.0 * this.weights.get(i) * (this.upper.get(i) / this.count - this.expectation[i] / (this.count * this.count));
                    }
                } else {
                    double ex = this.expectation[i];
                    if (ex < this.lower.get(i)) {
                        return 2.0 * this.weights.get(i) * (this.lower.get(i) - this.expectation[i]);
                    }
                    if (ex > this.upper.get(i)) {
                        return 2.0 * this.weights.get(i) * (this.upper.get(i) - this.expectation[i]);
                    }
                }
            }
            return 0.0;
        }
    }
}

