/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.linnaeus;

import de.julielab.jcore.ae.linnaeus.LinnaeusMatcherProvider;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import martin.common.ArgParser;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.man.entitytagger.EntityTagger;
import uk.ac.man.entitytagger.matching.Matcher;

public class LinnaeusMatcherProviderImpl
implements LinnaeusMatcherProvider {
    private static final Logger log = LoggerFactory.getLogger(LinnaeusMatcherProviderImpl.class);
    private Matcher matcher;

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    public void load(DataResource aData) throws ResourceInitializationException {
        Object configFile;
        URI uri = aData.getUri();
        if (aData.getUrl() != null && !aData.getUrl().toString().contains("!")) {
            try {
                log.info("Loading LINNAUS configuration from file {}", (Object)aData.getUrl());
                configFile = new File(aData.getUrl().toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        } else if (this.getClass().getResource(uri.toString()) != null || aData.getUri().toString().contains("!")) {
            String classpathResource = uri.toString();
            if (classpathResource.contains("!")) {
                classpathResource = classpathResource.substring(classpathResource.indexOf(33) + 1);
            }
            log.info("Loading LINNAEUS configuration as classpath resource from {}", (Object)classpathResource);
            configFile = "internal:" + classpathResource;
        } else {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("Could not find the LINNAEUS configuration as a file or a classpath resource at " + uri.toString()));
        }
        ArgParser ap = new ArgParser(new String[]{"--properties", configFile});
        this.matcher = EntityTagger.getMatcher((ArgParser)ap, (java.util.logging.Logger)java.util.logging.Logger.getLogger("global"));
    }
}

