/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.linnaeus;

import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.ResourceEntry;
import de.julielab.jcore.utility.JCoReTools;
import java.util.List;
import java.util.logging.Logger;
import martin.common.ArgParser;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import uk.ac.man.entitytagger.EntityTagger;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

public class LinnaeusSpeciesAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_CONFIG_FILE = "ConfigFile";
    private Matcher matcher;
    private Logger logger;
    @ConfigurationParameter(name="ConfigFile", mandatory=true, defaultValue={"internal:/linnaeus-properties.conf"})
    private String configFile;
    private static final String linnaeusIdPrefix = "species:ncbi:";

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.logger = Logger.getLogger("global");
        this.configFile = (String)aContext.getConfigParameterValue(PARAM_CONFIG_FILE);
        if (this.configFile == null) {
            throw new ResourceInitializationException("config_setting_absent", new Object[]{PARAM_CONFIG_FILE});
        }
        ArgParser ap = new ArgParser(new String[]{"--properties", this.configFile});
        this.matcher = EntityTagger.getMatcher((ArgParser)ap, (Logger)this.logger);
        super.initialize(aContext);
    }

    public void process(JCas cas) throws AnalysisEngineProcessException {
        String text = cas.getDocumentText();
        List mentions = this.matcher.match(text);
        for (Mention mention : mentions) {
            String mostProbableID = mention.getMostProbableID();
            if (mostProbableID.startsWith(linnaeusIdPrefix)) {
                mostProbableID = mostProbableID.substring(linnaeusIdPrefix.length());
            }
            Double[] probabilities = mention.getProbabilities();
            double maxprob = 0.0;
            if (probabilities != null) {
                for (int i = 0; i < probabilities.length; ++i) {
                    if (probabilities[i] == null || !(probabilities[i] > maxprob)) continue;
                    maxprob = probabilities[i];
                }
            }
            int start = mention.getStart();
            int end = mention.getEnd();
            try {
                Organism species = null;
                species = new Organism(cas);
                species.setBegin(mention.getStart());
                species.setEnd(mention.getEnd());
                species.setSpecificType("organism");
                species.addToIndexes();
                ResourceEntry resourceEntry = new ResourceEntry(cas);
                resourceEntry.setBegin(start);
                resourceEntry.setEnd(end);
                resourceEntry.setSource("NCBI Taxonomy");
                resourceEntry.setComponentId(((Object)((Object)this)).getClass().getCanonicalName());
                resourceEntry.setEntryId(mostProbableID);
                resourceEntry.setConfidence(String.valueOf(maxprob));
                resourceEntry.addToIndexes();
                FSArray resourceEntryList = species.getResourceEntryList();
                if (null == resourceEntryList) {
                    resourceEntryList = new FSArray(cas, 1);
                    resourceEntryList.set(0, (FeatureStructure)resourceEntry);
                } else {
                    resourceEntryList = JCoReTools.addToFSArray((FSArray)resourceEntryList, (FeatureStructure)resourceEntry);
                }
                species.setResourceEntryList(resourceEntryList);
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.matcher = null;
        super.collectionProcessComplete();
    }
}

