/*
 * Decompiled with CFR 0.152.
 */
package lingscope.structures;

import java.util.ArrayList;
import java.util.List;

public class AnnotatedSentence {
    public static String nonScopeTag = "O";
    private String rawText;
    private List<String> words = new ArrayList<String>();
    private List<String> tags = new ArrayList<String>();
    private List<Boolean> isAnnotatedTags = new ArrayList<Boolean>();

    public AnnotatedSentence() {
    }

    public AnnotatedSentence(String rawText) {
        this();
        this.processRawText(rawText);
    }

    public final void processRawText(String rawText) {
        String[] tokens;
        this.rawText = rawText;
        this.words.clear();
        this.tags.clear();
        this.isAnnotatedTags.clear();
        for (String token : tokens = rawText.split("\\s+")) {
            String[] wordTag = token.split("\\|");
            this.words.add(wordTag[0]);
            this.tags.add(wordTag[1]);
            if (nonScopeTag.equalsIgnoreCase(wordTag[1])) {
                this.isAnnotatedTags.add(Boolean.FALSE);
                continue;
            }
            this.isAnnotatedTags.add(Boolean.TRUE);
        }
    }

    public List<Boolean> getIsAnnotatedTags() {
        return this.isAnnotatedTags;
    }

    public String getRawText() {
        return this.rawText;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getWords() {
        return this.words;
    }

    public String getSentenceText() {
        StringBuilder sentenceText = new StringBuilder();
        for (String word : this.words) {
            sentenceText.append(" ").append(word);
        }
        if (sentenceText.length() == 0) {
            return "";
        }
        return sentenceText.substring(1);
    }
}

