/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import lingscope.algorithms.AbnerTokenizer;
import lingscope.algorithms.NegexAnnotator;
import lingscope.structures.AnnotatedSentence;

public class NegexScopeAnnotator
extends NegexAnnotator {
    public NegexScopeAnnotator(String beginTag, String interTag, String otherTag) {
        super(beginTag, interTag, otherTag);
    }

    @Override
    public AnnotatedSentence annotateSentence(String sentence, boolean isTokenized) {
        if (this.negex == null) {
            throw new RuntimeException("Annotator has not been loaded");
        }
        if (!isTokenized) {
            sentence = AbnerTokenizer.splitTermsByPunctuation(sentence);
        }
        String raw = this.negex.getScope(sentence, this.rules, this.beginTag, this.interTag, this.otherTag);
        return new AnnotatedSentence(raw);
    }
}

