/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import abner.Tagger;
import abner.Trainer;
import java.io.InputStream;
import lingscope.algorithms.AbnerTokenizer;
import lingscope.algorithms.Annotator;
import lingscope.structures.AnnotatedSentence;

public class CrfAnnotator
extends Annotator {
    private Tagger tagger = null;

    public CrfAnnotator(String beginTag, String interTag, String otherTag) {
        super(beginTag, interTag, otherTag);
    }

    @Override
    public void serializeAnnotator(String trainingFile, String modelFile) {
        Trainer trainer = new Trainer();
        trainer.train(trainingFile, modelFile);
        this.loadAnnotator(modelFile);
    }

    @Override
    public AnnotatedSentence annotateSentence(String sentence, boolean isTokenized) {
        if (this.tagger == null) {
            throw new RuntimeException("Tagger has not been loaded");
        }
        if (!isTokenized) {
            sentence = AbnerTokenizer.splitTermsByPunctuation(sentence);
        }
        String raw = this.tagger.tagABNER(sentence).trim();
        return new AnnotatedSentence(raw);
    }

    @Override
    public void loadAnnotator(InputStream is) {
        this.tagger = new Tagger(is);
        this.tagger.setTokenization(false);
    }
}

