/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lingscope.algorithms.AbnerTokenizer;
import lingscope.algorithms.BaselineAnnotator;
import lingscope.structures.AnnotatedSentence;

public class BaselineScopeAnnotator
extends BaselineAnnotator {
    protected Pattern endPattern;

    public BaselineScopeAnnotator(String beginTag, String interTag, String otherTag, boolean commaLimit, boolean periodLimit) {
        super(beginTag, interTag, otherTag);
        String endPatternString = "";
        if (commaLimit && periodLimit) {
            endPatternString = ",|\\.";
        } else if (commaLimit) {
            endPatternString = ",";
        } else if (periodLimit) {
            endPatternString = "\\.";
        }
        this.endPattern = Pattern.compile(endPatternString);
    }

    @Override
    public AnnotatedSentence annotateSentence(String sentence, boolean isTokenized) {
        if (this.phrases == null) {
            throw new RuntimeException("Annotator has not been loaded");
        }
        if (!isTokenized) {
            sentence = AbnerTokenizer.splitTermsByPunctuation(sentence);
        }
        String lcSentence = sentence.toLowerCase();
        String[] words = sentence.split(" +");
        int wordsLength = words.length;
        HashSet<Integer> addBTag = new HashSet<Integer>();
        for (String phrase : this.phrases) {
            if (!lcSentence.contains(phrase)) continue;
            String[] phraseWords = phrase.split(" +");
            for (int wordCounter = 0; wordCounter < wordsLength; ++wordCounter) {
                String word = words[wordCounter];
                if (!word.equalsIgnoreCase(phraseWords[0])) continue;
                boolean phraseMatches = true;
                for (int j = 0; j < phraseWords.length; ++j) {
                    int i = j + wordCounter;
                    if (i == wordsLength) {
                        phraseMatches = false;
                        break;
                    }
                    if (phraseWords[j].equalsIgnoreCase(words[i])) continue;
                    phraseMatches = false;
                    break;
                }
                if (!phraseMatches) continue;
                addBTag.add(wordCounter);
            }
        }
        StringBuilder taggedSentence = new StringBuilder();
        boolean taggerOn = false;
        for (int i = 0; i < wordsLength; ++i) {
            String word = words[i];
            if (addBTag.contains(i)) {
                taggedSentence.append(" ").append(word).append("|").append(this.beginTag);
                taggerOn = true;
                continue;
            }
            if (taggerOn) {
                Matcher endMatch = this.endPattern.matcher(word);
                if (endMatch.matches()) {
                    taggedSentence.append(" ").append(word).append("|").append(this.otherTag);
                    taggerOn = false;
                    continue;
                }
                taggedSentence.append(" ").append(word).append("|").append(this.interTag);
                continue;
            }
            taggedSentence.append(" ").append(word).append("|").append(this.otherTag);
        }
        String raw = taggedSentence.substring(1);
        return new AnnotatedSentence(raw);
    }
}

