/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import java.util.HashSet;
import lingscope.algorithms.AbnerTokenizer;
import lingscope.algorithms.BaselineAnnotator;
import lingscope.structures.AnnotatedSentence;

public class BaselineCueAnnotator
extends BaselineAnnotator {
    public BaselineCueAnnotator(String beginTag, String interTag, String otherTag) {
        super(beginTag, interTag, otherTag);
    }

    @Override
    public AnnotatedSentence annotateSentence(String sentence, boolean isTokenized) {
        if (this.phrases == null) {
            throw new RuntimeException("Annotator has not been loaded");
        }
        if (!isTokenized) {
            sentence = AbnerTokenizer.splitTermsByPunctuation(sentence);
        }
        String lcSentence = sentence.toLowerCase();
        String[] words = sentence.split(" +");
        int wordsLength = words.length;
        HashSet<Integer> addITag = new HashSet<Integer>();
        HashSet<Integer> addBTag = new HashSet<Integer>();
        for (String phrase : this.phrases) {
            if (!lcSentence.contains(phrase)) continue;
            String[] phraseWords = phrase.split(" +");
            for (int wordCounter = 0; wordCounter < wordsLength; ++wordCounter) {
                int j;
                String word = words[wordCounter];
                if (!word.equalsIgnoreCase(phraseWords[0])) continue;
                boolean phraseMatches = true;
                for (j = 0; j < phraseWords.length; ++j) {
                    int i = j + wordCounter;
                    if (i == wordsLength) {
                        phraseMatches = false;
                        break;
                    }
                    if (phraseWords[j].equalsIgnoreCase(words[i])) continue;
                    phraseMatches = false;
                    break;
                }
                if (!phraseMatches) continue;
                addBTag.add(wordCounter);
                for (j = 1; j < phraseWords.length; ++j) {
                    addITag.add(j + wordCounter);
                }
            }
        }
        StringBuilder taggedSentence = new StringBuilder();
        for (int i = 0; i < wordsLength; ++i) {
            String word = words[i];
            if (addBTag.contains(i)) {
                taggedSentence.append(" ").append(word).append("|").append(this.beginTag);
                continue;
            }
            if (addITag.contains(i)) {
                taggedSentence.append(" ").append(word).append("|").append(this.interTag);
                continue;
            }
            taggedSentence.append(" ").append(word).append("|").append(this.otherTag);
        }
        String raw = taggedSentence.substring(1);
        return new AnnotatedSentence(raw);
    }
}

