/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.lingscope;

import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikelihoodUtils {
    private static final Logger log = LoggerFactory.getLogger(LikelihoodUtils.class);

    public static void loadLikelihoodDict(String dictFilePath, Map<String, String> likelihoodDict) {
        try {
            InputStream resource = FileUtilities.findResource((String)dictFilePath);
            if (resource == null) {
                log.error("ERR: Could not find likelihood dictionary file (path: " + dictFilePath + ")");
                throw new IllegalArgumentException("Could not find likelihood dictionary at " + dictFilePath);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource));){
                String line = "";
                while ((line = reader.readLine()) != null) {
                    String[] entry = line.split("\t");
                    if (entry.length != 2) {
                        log.error("ERR: Likelihood dictionary file not in expected format. Critical line: " + line);
                        throw new IllegalArgumentException("Likelihood dictionary has the wrong format (expected: two tab-separated columns). Critical line: " + line);
                    }
                    String indicator = entry[0].trim();
                    String category = entry[1].trim();
                    likelihoodDict.put(indicator, category);
                }
                reader.close();
                log.info("Done loading likelihood dictionary.");
            }
            catch (IOException e) {
                log.error("Could not read the likelihood dictionary from {}", (Object)dictFilePath, (Object)e);
            }
        }
        catch (IOException e) {
            log.error("Could not read the likelihood dictionary from {}", (Object)dictFilePath, (Object)e);
        }
    }
}

