/*
 * Decompiled with CFR 0.152.
 */
package lingscope.drivers;

import generalutils.FileOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lingscope.io.AnnotatedSentencesIO;
import lingscope.structures.AnnotatedSentence;

public class CueAndPosFilesMerger {
    public static AnnotatedSentence merge(AnnotatedSentence cueSentence, String posSentence, boolean replaceTags) {
        String[] posTags = posSentence.split("\\s+");
        List<String> crfTags = cueSentence.getTags();
        List<String> words = cueSentence.getWords();
        List<Boolean> tagStatusList = cueSentence.getIsAnnotatedTags();
        StringBuilder mergedSentence = new StringBuilder();
        int numWords = posTags.length;
        for (int j = 0; j < numWords; ++j) {
            mergedSentence.append(" ");
            String posTag = posTags[j];
            String word = words.get(j);
            String crfTag = crfTags.get(j);
            boolean tagStatus = tagStatusList.get(j);
            if (tagStatus) {
                if (replaceTags) {
                    mergedSentence.append("CUE|");
                } else {
                    mergedSentence.append(word).append("|");
                }
            } else {
                mergedSentence.append(posTag).append("|");
            }
            mergedSentence.append(crfTag);
        }
        AnnotatedSentence mergedAnnotatedSentence = new AnnotatedSentence(mergedSentence.substring(1));
        return mergedAnnotatedSentence;
    }

    public static List<AnnotatedSentence> merge(List<AnnotatedSentence> cueSentences, List<String> posSentences, boolean replaceTags) {
        ArrayList<AnnotatedSentence> mergedSentences = new ArrayList<AnnotatedSentence>(cueSentences.size());
        int numSentences = posSentences.size();
        for (int i = 0; i < numSentences; ++i) {
            AnnotatedSentence cueSentence = cueSentences.get(i);
            String posSentence = posSentences.get(i);
            AnnotatedSentence mergedAnnotatedSentence = CueAndPosFilesMerger.merge(cueSentence, posSentence, replaceTags);
            mergedSentences.add(mergedAnnotatedSentence);
        }
        return mergedSentences;
    }

    public static void main(String[] args) {
        boolean replaceTags = Boolean.parseBoolean(args[2]);
        List<AnnotatedSentence> cueSentences = AnnotatedSentencesIO.read(args[0]);
        List<String> posSentences = null;
        try {
            posSentences = FileOperations.readFile(args[1]);
        }
        catch (Exception ex) {
            Logger.getLogger(CueAndPosFilesMerger.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(1);
        }
        AnnotatedSentencesIO.write(args[3], CueAndPosFilesMerger.merge(cueSentences, posSentences, replaceTags));
    }
}

