/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import de.julielab.java.utilities.IOStreamUtilities;
import generalutils.FileOperations;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lingscope.algorithms.Annotator;

public abstract class BaselineAnnotator
extends Annotator {
    protected Set<String> phrases = null;

    public BaselineAnnotator(String beginTag, String interTag, String otherTag) {
        super(beginTag, interTag, otherTag);
    }

    @Override
    public void serializeAnnotator(String trainingFile, String modelFile) {
        try {
            this.phrases = new HashSet<String>();
            List<String> taggedSentences = FileOperations.readFile(trainingFile);
            for (String taggedSentence : taggedSentences) {
                this.phrases.addAll(BaselineAnnotator.getCueWords(taggedSentence, this.beginTag, this.interTag, this.otherTag));
            }
            FileOperations.writeFile(modelFile, new ArrayList<String>(this.phrases));
        }
        catch (Exception ex) {
            Logger.getLogger(BaselineAnnotator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void loadAnnotator(InputStream is) {
        try (BufferedReader br = IOStreamUtilities.getReaderFromInputStream((InputStream)is);){
            this.phrases = br.lines().collect(Collectors.toSet());
        }
        catch (Exception ex) {
            Logger.getLogger(BaselineAnnotator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Set<String> getCueWords(String abnerTaggedSentence, String beginTag, String intermediateTag, String otherTag) {
        HashSet<String> cueWordsPhrases = new HashSet<String>(1);
        String[] elements = abnerTaggedSentence.split(" +");
        boolean collect = false;
        StringBuilder collectedPhrase = new StringBuilder();
        for (String element : elements) {
            String[] elementTokens = element.split("\\|");
            String word = elementTokens[0];
            String tag = elementTokens[1];
            if (tag.equalsIgnoreCase(beginTag)) {
                collect = true;
                collectedPhrase.append(word).append(" ");
                continue;
            }
            if (tag.equalsIgnoreCase(intermediateTag)) {
                collectedPhrase.append(word).append(" ");
                continue;
            }
            if (!tag.equalsIgnoreCase(otherTag) || !collect) continue;
            collect = false;
            cueWordsPhrases.add(collectedPhrase.toString().trim().toLowerCase());
            collectedPhrase.delete(0, collectedPhrase.length() - 1);
        }
        return cueWordsPhrases;
    }
}

