/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import java.util.List;
import lingscope.io.AnnotatedSentencesIO;
import lingscope.structures.AnnotatedSentence;

public class AnnotationComparer {
    private double tp;
    private double fp;
    private double fn;
    private double tn;
    private double perfectMatches;
    private int totalSentences;
    private int numFolds;
    private double[] tpFolds;
    private double[] fpFolds;
    private double[] fnFolds;
    private double[] tnFolds;
    private double[] perfectMatchesFolds;
    private double[] totalSentencesFolds;

    public AnnotationComparer(int numFolds) {
        this.numFolds = numFolds;
        this.reset();
    }

    public final void reset() {
        this.tp = 0.0;
        this.fp = 0.0;
        this.fn = 0.0;
        this.tn = 0.0;
        this.perfectMatches = 0.0;
        this.totalSentences = 0;
        this.tpFolds = new double[this.numFolds];
        this.resetFold(this.tpFolds, this.numFolds);
        this.fpFolds = new double[this.numFolds];
        this.resetFold(this.fpFolds, this.numFolds);
        this.fnFolds = new double[this.numFolds];
        this.resetFold(this.fnFolds, this.numFolds);
        this.tnFolds = new double[this.numFolds];
        this.resetFold(this.tnFolds, this.numFolds);
        this.perfectMatchesFolds = new double[this.numFolds];
        this.resetFold(this.perfectMatchesFolds, this.numFolds);
        this.totalSentencesFolds = new double[this.numFolds];
        this.resetFold(this.totalSentencesFolds, this.numFolds);
    }

    private void resetFold(double[] folds, int numFolds) {
        for (int i = 0; i < numFolds; ++i) {
            folds[i] = 0.0;
        }
    }

    public void compareAnnotationFiles(String goldFile, String testFile) {
        List<AnnotatedSentence> goldSentences = AnnotatedSentencesIO.read(goldFile);
        List<AnnotatedSentence> testSentences = AnnotatedSentencesIO.read(testFile);
        if (goldSentences.size() != testSentences.size()) {
            throw new RuntimeException("Number of sentences in gold and test file are not same");
        }
        for (int i = 0; i < goldSentences.size(); ++i) {
            AnnotatedSentence goldSentence = goldSentences.get(i);
            AnnotatedSentence testSentence = testSentences.get(i);
            this.compareAnnotations(goldSentence, testSentence);
        }
    }

    public void compareAnnotations(AnnotatedSentence goldSentence, AnnotatedSentence testSentence) {
        int localTp = 0;
        int localFp = 0;
        int localFn = 0;
        int localTn = 0;
        if (goldSentence.getIsAnnotatedTags().size() != testSentence.getIsAnnotatedTags().size()) {
            System.err.println("Size mismatch GOLD: " + goldSentence.getRawText());
            System.err.println("Size mismatch TEST: " + testSentence.getRawText());
        }
        int numTags = Math.min(goldSentence.getIsAnnotatedTags().size(), testSentence.getIsAnnotatedTags().size());
        for (int i = 0; i < numTags; ++i) {
            boolean goldTag = goldSentence.getIsAnnotatedTags().get(i);
            boolean testTag = testSentence.getIsAnnotatedTags().get(i);
            if (goldTag && testTag) {
                ++localTp;
                continue;
            }
            if (goldTag && !testTag) {
                ++localFn;
                continue;
            }
            if (!goldTag && testTag) {
                ++localFp;
                continue;
            }
            if (goldTag || testTag) continue;
            ++localTn;
        }
        int foldNum = this.totalSentences % this.numFolds;
        this.tp += (double)localTp;
        this.fp += (double)localFp;
        this.fn += (double)localFn;
        this.tn += (double)localTn;
        int n = foldNum;
        this.tpFolds[n] = this.tpFolds[n] + (double)localTp;
        int n2 = foldNum;
        this.fpFolds[n2] = this.fpFolds[n2] + (double)localFp;
        int n3 = foldNum;
        this.fnFolds[n3] = this.fnFolds[n3] + (double)localFn;
        int n4 = foldNum;
        this.tnFolds[n4] = this.tnFolds[n4] + (double)localTn;
        if (localFp != 0) {
            System.out.println("FP Gold: " + goldSentence.getRawText());
            System.out.println("FP Test: " + testSentence.getRawText());
        }
        if (localFn != 0) {
            System.out.println("FN Gold: " + goldSentence.getRawText());
            System.out.println("FN Test: " + testSentence.getRawText());
        }
        if (localFp == 0 && localFn == 0) {
            this.perfectMatches += 1.0;
            int n5 = foldNum;
            this.perfectMatchesFolds[n5] = this.perfectMatchesFolds[n5] + 1.0;
        }
        ++this.totalSentences;
        int n6 = foldNum;
        this.totalSentencesFolds[n6] = this.totalSentencesFolds[n6] + 1.0;
    }

    public void printStats() {
        System.out.println("TP: " + this.tp);
        System.out.println("FP: " + this.fp);
        System.out.println("FN: " + this.fn);
        System.out.println("TN: " + this.tn);
        double precision = this.getPrecision(this.tp, this.fp);
        double recall = this.getRecall(this.tp, this.fn);
        System.out.println("Overall precision: " + precision);
        System.out.println("Overall recall: " + recall);
        System.out.println("Overall F1-score: " + this.getFScore(recall, precision));
        System.out.println("Overall Accuracy: " + this.getAccuracy(this.tp, this.fp, this.fn, this.tn));
        System.out.println("Overall Perfect : " + this.getPerfectAccuracy(this.perfectMatches, this.totalSentences));
        double[] recalls = this.getRecalls();
        double[] precisions = this.getPrecisions();
        double[] fScores = this.getFScores(recalls, precisions);
        double[] accuracies = this.getAccuracies();
        double[] perfectAccuracies = this.getPerfectAccuracies();
        System.out.println("WARNING: Here should have been printed average scores. However, the lines were removed from the JCoRe version because a required class was not available. This should be easy to fix if required.");
    }

    public double[] getRecalls() {
        double[] recalls = new double[this.numFolds];
        for (int i = 0; i < this.numFolds; ++i) {
            recalls[i] = this.getRecall(this.tpFolds[i], this.fnFolds[i]);
        }
        return recalls;
    }

    public double[] getPrecisions() {
        double[] precisions = new double[this.numFolds];
        for (int i = 0; i < this.numFolds; ++i) {
            precisions[i] = this.getPrecision(this.tpFolds[i], this.fpFolds[i]);
        }
        return precisions;
    }

    public double[] getFScores(double[] recalls, double[] precisions) {
        double[] fScores = new double[this.numFolds];
        for (int i = 0; i < this.numFolds; ++i) {
            fScores[i] = this.getFScore(recalls[i], precisions[i]);
        }
        return fScores;
    }

    public double[] getAccuracies() {
        double[] accuracies = new double[this.numFolds];
        for (int i = 0; i < this.numFolds; ++i) {
            accuracies[i] = this.getAccuracy(this.tpFolds[i], this.fpFolds[i], this.fnFolds[i], this.tnFolds[i]);
        }
        return accuracies;
    }

    public double[] getPerfectAccuracies() {
        double[] pcss = new double[this.numFolds];
        for (int i = 0; i < this.numFolds; ++i) {
            pcss[i] = this.getPerfectAccuracy(this.perfectMatchesFolds[i], this.totalSentencesFolds[i]);
        }
        return pcss;
    }

    public double getPerfectAccuracy(double trues, double total) {
        return trues / total;
    }

    public double getAccuracy(double tp, double fp, double fn, double tn) {
        return (tp + tn) / (tp + fp + fn + tn);
    }

    public double getRecall(double tp, double fn) {
        return tp / (tp + fn);
    }

    public double getPrecision(double tp, double fp) {
        return tp / (tp + fp);
    }

    public double getFScore(double recall, double precision) {
        return 2.0 * precision * recall / (recall + precision);
    }
}

