/*
 * Decompiled with CFR 0.152.
 */
package lingscope.drivers;

import generalutils.FileOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lingscope.algorithms.Annotator;
import lingscope.algorithms.BaselineCueAnnotator;
import lingscope.algorithms.BaselineScopeAnnotator;
import lingscope.algorithms.CrfAnnotator;
import lingscope.algorithms.NegexCueAnnotator;
import lingscope.algorithms.NegexScopeAnnotator;
import lingscope.io.AnnotatedSentencesIO;
import lingscope.structures.AnnotatedSentence;

public class SentenceTagger {
    public static final String CUE_START = "B-C";
    public static final String CUE_INTER = "I-C";
    public static final String SCOPE_START = "B-S";
    public static final String SCOPE_INTER = "I-S";
    public static final String OTHER = "O";

    public static AnnotatedSentence tag(Annotator annotator, String sentence, boolean isTokenized) {
        return annotator.annotateSentence(sentence, isTokenized);
    }

    public static void usage() {
        System.out.println("Usage:\njava lingscope.drivers.SentenceTagger (cue|scope) (crf|baseline|negex) saved_model_file sentence_to_tag");
        System.out.println("\tSaved model for negation can be obtained from http://negscope.askhermes.org/");
        System.out.println("\tSaved model for speculation can be obtained from http://hedgescope.askhermes.org/");
        System.out.println("\tSaved model for NegEx can be obtained from http://code.google.com/p/negex/downloads/list");
    }

    public static List<String> getStringListFromAnnotatedSentences(List<AnnotatedSentence> annotatedSentences) {
        ArrayList<String> strings = new ArrayList<String>(annotatedSentences.size());
        for (AnnotatedSentence annotatedSentence : annotatedSentences) {
            strings.add(annotatedSentence.getSentenceText());
        }
        return strings;
    }

    public static List<AnnotatedSentence> annotateSentences(Annotator annotator, List<String> inputSentences, boolean isTokenized) {
        ArrayList<AnnotatedSentence> outputSentences = new ArrayList<AnnotatedSentence>(inputSentences.size());
        for (String inputSentence : inputSentences) {
            AnnotatedSentence outputSentence = annotator.annotateSentence(inputSentence, isTokenized);
            outputSentences.add(outputSentence);
        }
        return outputSentences;
    }

    public static List<String> getStringList(String inputFile, boolean isAnnotated) {
        if (!isAnnotated) {
            try {
                return FileOperations.readFile(inputFile);
            }
            catch (Exception ex) {
                Logger.getLogger(SentenceTagger.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        List<AnnotatedSentence> annotatedSentences = AnnotatedSentencesIO.read(inputFile);
        return SentenceTagger.getStringListFromAnnotatedSentences(annotatedSentences);
    }

    public static Annotator getAnnotator(String classifierType, String markType) {
        if ("cue".equalsIgnoreCase(markType)) {
            if ("baseline".equalsIgnoreCase(classifierType)) {
                return new BaselineCueAnnotator(CUE_START, CUE_INTER, OTHER);
            }
            if ("crf".equalsIgnoreCase(classifierType)) {
                return new CrfAnnotator(CUE_START, CUE_INTER, OTHER);
            }
            if ("negex".equalsIgnoreCase(classifierType)) {
                return new NegexCueAnnotator(CUE_START, CUE_INTER, OTHER);
            }
            return null;
        }
        if ("scope".equalsIgnoreCase(markType)) {
            if ("baseline".equalsIgnoreCase(classifierType)) {
                return new BaselineScopeAnnotator(SCOPE_START, SCOPE_INTER, OTHER, true, true);
            }
            if ("crf".equalsIgnoreCase(classifierType)) {
                return new CrfAnnotator(SCOPE_START, SCOPE_INTER, OTHER);
            }
            if ("negex".equalsIgnoreCase(classifierType)) {
                return new NegexScopeAnnotator(SCOPE_START, SCOPE_INTER, OTHER);
            }
            return null;
        }
        return null;
    }

    public static void main(String[] args) {
        Annotator annotator;
        if (args.length < 4) {
            SentenceTagger.usage();
            System.exit(0);
        }
        if ((annotator = SentenceTagger.getAnnotator(args[1], args[0])) == null) {
            SentenceTagger.usage();
            System.exit(1);
        }
        annotator.loadAnnotator(args[2]);
        if ("file".equalsIgnoreCase(args[3])) {
            String fileName = args[4];
            try {
                List<String> sentences = FileOperations.readFile(fileName);
                for (String sentence : sentences) {
                    AnnotatedSentence annotatedSentence = SentenceTagger.tag(annotator, sentence, false);
                    System.out.println(annotatedSentence.getRawText());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else {
            AnnotatedSentence sentence = SentenceTagger.tag(annotator, args[3], false);
            System.out.println(sentence.getRawText());
        }
    }
}

