/*
 * Decompiled with CFR 0.152.
 */
package lingscope.drivers;

import generalutils.FileOperations;
import java.util.List;
import lingscope.algorithms.Annotator;
import lingscope.drivers.AnnotatedFilesMerger;
import lingscope.drivers.CueAndPosFilesMerger;
import lingscope.drivers.PosTaggerDriver;
import lingscope.drivers.SentenceTagger;
import lingscope.structures.AnnotatedSentence;

public class SentencePosTagger {
    public static void usage() {
        System.out.println("java lingscope.drivers.SentencePosTagger cue_tagging_model cue_tagger_type(baseline|crf|negex) replace_cue_with_custom_tag(true|false) scope_tagging_model pos_model_file sentence_to_tag");
        System.out.println("\tSaved model for negation can be obtained from http://negscope.askhermes.org/");
        System.out.println("\tSaved model for speculation can be obtained from http://hedgescope.askhermes.org/");
        System.out.println("\tSaved model for NegEx can be obtained from http://code.google.com/p/negex/downloads/list");
        System.out.println("\tSaved pos_model_file can be obtained from http://hedgescope.askhermes.org/");
    }

    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("help")) {
            SentencePosTagger.usage();
            System.exit(0);
        } else if (args.length < 6) {
            SentencePosTagger.usage();
            System.exit(1);
        }
        Annotator cueAnnotator = SentenceTagger.getAnnotator(args[1], "cue");
        cueAnnotator.loadAnnotator(args[0]);
        Annotator scopeAnnotator = SentenceTagger.getAnnotator("crf", "scope");
        scopeAnnotator.loadAnnotator(args[3]);
        String sentence = args[5];
        String grammarFile = args[4];
        if ("file".equalsIgnoreCase(sentence)) {
            String sentencesFile = args[6];
            try {
                List<String> sentences = FileOperations.readFile(sentencesFile);
                for (String sentenceText : sentences) {
                    SentencePosTagger.tagSentence(sentenceText, grammarFile, Boolean.parseBoolean(args[2]), cueAnnotator, scopeAnnotator);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else {
            SentencePosTagger.tagSentence(sentence, grammarFile, Boolean.parseBoolean(args[2]), cueAnnotator, scopeAnnotator);
        }
    }

    public static void tagSentence(String sentence, String grammarFile, boolean replaceCueWords, Annotator cueAnnotator, Annotator scopeAnnotator) {
        String posSentence = PosTaggerDriver.getTaggedSentence(grammarFile, sentence, false);
        AnnotatedSentence cueTaggedSentence = cueAnnotator.annotateSentence(sentence, false);
        AnnotatedSentence posCueMerged = CueAndPosFilesMerger.merge(cueTaggedSentence, posSentence, replaceCueWords);
        AnnotatedSentence scopeMarkedSentence = scopeAnnotator.annotateSentence(posCueMerged.getSentenceText(), true);
        AnnotatedSentence scopeWordsMarkedSentence = AnnotatedFilesMerger.merge(cueTaggedSentence, scopeMarkedSentence);
        System.out.println(scopeWordsMarkedSentence.getRawText());
    }
}

