/*
 * Decompiled with CFR 0.152.
 */
package lingscope.drivers;

import generalutils.FileOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lingscope.algorithms.PosTagger;
import lingscope.drivers.SentenceTagger;

public class PosTaggerDriver {
    private static PosTagger posTagger = null;

    public static String getTaggedSentence(String grammerFile, String sentenceToTag, boolean isTokenized) {
        if (posTagger == null) {
            posTagger = new PosTagger(grammerFile);
        }
        List<String> posTags = posTagger.replaceWordsWithPos(sentenceToTag, isTokenized);
        StringBuilder posSentence = new StringBuilder();
        for (String posTag : posTags) {
            posSentence.append(" ").append(posTag);
        }
        return posSentence.substring(1);
    }

    public static void main(String[] args) {
        String grammarFile = args[0];
        List<String> inputSentences = SentenceTagger.getStringList(args[1], Boolean.parseBoolean(args[3]));
        ArrayList<String> outputSentences = new ArrayList<String>(inputSentences.size());
        for (String inputSentence : inputSentences) {
            String outputSentence = PosTaggerDriver.getTaggedSentence(grammarFile, inputSentence, Boolean.parseBoolean(args[3]));
            outputSentences.add(outputSentence);
        }
        try {
            FileOperations.writeFile(args[2], outputSentences);
        }
        catch (Exception ex) {
            Logger.getLogger(PosTaggerDriver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

