/*
 * Decompiled with CFR 0.152.
 */
package lingscope.drivers;

import java.util.ArrayList;
import java.util.List;
import lingscope.io.AnnotatedSentencesIO;
import lingscope.structures.AnnotatedSentence;

public class AnnotatedFilesMerger {
    public static AnnotatedSentence merge(AnnotatedSentence wordsSentence, AnnotatedSentence tagsSentence) {
        List<String> words = wordsSentence.getWords();
        List<String> tags = tagsSentence.getTags();
        int numTokens = words.size();
        if (tags.size() != numTokens) {
            System.err.println("Skipping non-equal length sentences");
            System.err.println("\tSentence 1: " + wordsSentence.getRawText());
            System.err.println("\tSentence 2: " + tagsSentence.getRawText());
            return null;
        }
        StringBuilder mergedSentence = new StringBuilder();
        for (int j = 0; j < numTokens; ++j) {
            mergedSentence.append(" ").append(words.get(j)).append("|").append(tags.get(j));
        }
        return new AnnotatedSentence(mergedSentence.substring(1));
    }

    public static void main(String[] args) {
        List<AnnotatedSentence> wordsSentences = AnnotatedSentencesIO.read(args[0]);
        List<AnnotatedSentence> tagsSentences = AnnotatedSentencesIO.read(args[1]);
        int numSentences = tagsSentences.size();
        ArrayList<AnnotatedSentence> mergedSentences = new ArrayList<AnnotatedSentence>(numSentences);
        for (int i = 0; i < numSentences; ++i) {
            AnnotatedSentence tagsSentence;
            AnnotatedSentence wordsSentence = wordsSentences.get(i);
            AnnotatedSentence mergedSentence = AnnotatedFilesMerger.merge(wordsSentence, tagsSentence = tagsSentences.get(i));
            if (mergedSentence == null) continue;
            mergedSentences.add(mergedSentence);
        }
        AnnotatedSentencesIO.write(args[2], mergedSentences);
    }
}

