/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms.negex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lingscope.algorithms.negex.Sorter;

public class GenNegEx {
    private String previousRunScope;
    private String[] sentenceWords;
    private String[] tags;

    public String getCue(String sentenceString, List<String> ruleStrings, String beginTag, String interTag, String otherTag) {
        this.tagNegation(sentenceString, ruleStrings);
        StringBuilder ret = new StringBuilder();
        boolean inScope = false;
        for (int i = 0; i < this.sentenceWords.length; ++i) {
            String tag = this.tags[i];
            String sentenceWord = this.sentenceWords[i];
            ret.append(" ").append(sentenceWord).append("|");
            if (tag.equalsIgnoreCase("cue")) {
                if (inScope) {
                    ret.append(interTag);
                    continue;
                }
                ret.append(beginTag);
                inScope = true;
                continue;
            }
            ret.append(otherTag);
            inScope = false;
        }
        return ret.substring(1);
    }

    public String getScope(String sentenceString, List<String> ruleStrings, String beginTag, String interTag, String otherTag) {
        this.tagNegation(sentenceString, ruleStrings);
        StringBuilder ret = new StringBuilder();
        boolean inScope = false;
        Pattern punct = Pattern.compile("\\p{Punct}");
        for (int i = 0; i < this.sentenceWords.length; ++i) {
            String tag = this.tags[i];
            String sentenceWord = this.sentenceWords[i];
            ret.append(" ").append(sentenceWord).append("|");
            Matcher m = punct.matcher(sentenceWord);
            if (m.matches()) {
                if (i + 1 == this.sentenceWords.length) {
                    ret.append(otherTag);
                    continue;
                }
                if (this.tags[i + 1].equalsIgnoreCase("other")) {
                    ret.append(otherTag);
                    continue;
                }
            }
            if (tag.equalsIgnoreCase("cue") || tag.equalsIgnoreCase("scope")) {
                if (inScope) {
                    ret.append(interTag);
                    continue;
                }
                ret.append(beginTag);
                inScope = true;
                continue;
            }
            ret.append(otherTag);
            inScope = false;
        }
        return ret.substring(1);
    }

    public void tagNegation(String sentenceString, List<String> ruleStrings) {
        Sorter s = new Sorter();
        this.sentenceWords = sentenceString.split("\\s+");
        this.tags = new String[this.sentenceWords.length];
        for (int i = 0; i < this.sentenceWords.length; ++i) {
            this.tags[i] = "other";
        }
        String sToReturn = "";
        String sScope = "";
        List<Object> sortedRules = new ArrayList();
        String filler = "__";
        boolean negPoss = false;
        sortedRules = s.sortRules(ruleStrings);
        Object sentence = "." + sentenceString + ".";
        for (String string : sortedRules) {
            Pattern p = Pattern.compile("[\\t]+");
            Object[] ruleTokens = p.split(string.trim());
            String[] ruleMembers = ruleTokens[0].trim().split(" ");
            Object rule2 = "";
            for (int i = 0; i < ruleMembers.length; ++i) {
                if (ruleMembers[i].equals("")) continue;
                rule2 = ruleMembers.length == 1 ? ruleMembers[i] : (String)rule2 + ruleMembers[i].trim() + "\\s+";
            }
            if (((String)rule2).endsWith("\\s+")) {
                rule2 = ((String)rule2).substring(0, ((String)rule2).lastIndexOf("\\s+"));
            }
            rule2 = "(?m)(?i)[[\\p{Punct}&&[^-_\\]\\[]]|\\s+](" + (String)rule2 + ")[[\\p{Punct}&&[^_]]|\\s+]";
            Pattern p2 = Pattern.compile(((String)rule2).trim());
            Matcher m = p2.matcher((CharSequence)sentence);
            Matcher m2 = p2.matcher((CharSequence)sentence);
            if (m2.find()) {
                System.out.println(Arrays.toString(ruleTokens));
                if (((String)ruleTokens[1]).equalsIgnoreCase("[PREN]") || ((String)ruleTokens[1]).equalsIgnoreCase("[POST]")) {
                    for (int i = 0; i < this.sentenceWords.length; ++i) {
                        int j;
                        boolean perfectMatch = true;
                        for (j = 0; j < ruleMembers.length; ++j) {
                            if (this.sentenceWords[i + j].equalsIgnoreCase(ruleMembers[j])) continue;
                            perfectMatch = false;
                            break;
                        }
                        if (!perfectMatch) continue;
                        for (j = 0; j < ruleMembers.length; ++j) {
                            this.tags[i + j] = "cue";
                        }
                    }
                }
            }
            while (m.find()) {
                sentence = m.replaceAll(" " + ((String)ruleTokens[1]).trim() + m.group().trim().replaceAll(" ", filler) + ((String)ruleTokens[1]).trim() + " ");
            }
        }
        String string = "\\s+|[^\\s]__";
        Pattern pSpace = Pattern.compile(string);
        String[] sentenceTokens = pSpace.split(((String)sentence).trim());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sentenceTokens.length; ++i) {
            sb.append(" ").append(sentenceTokens[i].trim());
            if (!sentenceTokens[i].trim().startsWith("[PREN]")) continue;
            for (int j = i + 1; !(j >= sentenceTokens.length || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[POST]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POSP]")); ++j) {
                if (this.tags[j].equalsIgnoreCase("cue")) continue;
                this.tags[j] = "scope";
            }
        }
        sentence = sb.toString().trim();
        pSpace = Pattern.compile(string);
        sentenceTokens = pSpace.split((CharSequence)sentence);
        StringBuilder sb2 = new StringBuilder();
        for (int i = sentenceTokens.length - 1; i > 0; --i) {
            sb2.insert(0, sentenceTokens[i] + " ");
            if (!sentenceTokens[i].trim().startsWith("[POST]")) continue;
            for (int j = i - 1; !(j <= 0 || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POSP]")); --j) {
                if (this.tags[j].equalsIgnoreCase("cue")) continue;
                this.tags[j] = "scope";
            }
        }
    }

    public String negCheck(String sentenceString, String phraseString, ArrayList ruleStrings, boolean negatePossible) throws Exception {
        Sorter s = new Sorter();
        Object sToReturn = "";
        String sScope = "";
        String sentencePortion = "";
        String filler = "_";
        boolean negPoss = negatePossible;
        boolean negationScope = true;
        List<String> sortedRules = s.sortRules(ruleStrings);
        Object sentence = "." + sentenceString + ".";
        String phrase = phraseString;
        Pattern pph = Pattern.compile(phrase.trim(), 2);
        Matcher mph = pph.matcher((CharSequence)sentence);
        while (mph.find()) {
            sentence = mph.replaceAll(" [PHRASE]" + mph.group().trim().replaceAll(" ", filler) + "[PHRASE]");
        }
        for (String rule : sortedRules) {
            Pattern p = Pattern.compile("[\\t]+");
            String[] ruleTokens = p.split(rule.trim());
            String[] ruleMembers = ruleTokens[0].trim().split(" ");
            Object rule2 = "";
            for (int i = 0; i <= ruleMembers.length - 1; ++i) {
                if (ruleMembers[i].equals("")) continue;
                rule2 = ruleMembers.length == 1 ? ruleMembers[i] : (String)rule2 + ruleMembers[i].trim() + "\\s+";
            }
            if (((String)rule2).endsWith("\\s+")) {
                rule2 = ((String)rule2).substring(0, ((String)rule2).lastIndexOf("\\s+"));
            }
            rule2 = "(?m)(?i)[[\\p{Punct}&&[^\\]\\[]]|\\s+](" + (String)rule2 + ")[[\\p{Punct}&&[^_]]|\\s+]";
            Pattern p2 = Pattern.compile(((String)rule2).trim());
            Matcher m = p2.matcher((CharSequence)sentence);
            while (m.find()) {
                sentence = m.replaceAll(" " + ruleTokens[1].trim() + m.group().trim().replaceAll(" ", filler) + ruleTokens[1].trim() + " ");
            }
        }
        Pattern pSpace = Pattern.compile("[\\s+]");
        String[] sentenceTokens = pSpace.split((CharSequence)sentence);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sentenceTokens.length; ++i) {
            sb.append(" " + sentenceTokens[i].trim());
            if (!sentenceTokens[i].trim().startsWith("[PREN]")) continue;
            for (int j = i + 1; !(j >= sentenceTokens.length || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[POST]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POSP]")); ++j) {
                if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[NEGATED]");
            }
        }
        sentence = sb.toString();
        pSpace = Pattern.compile("[\\s+]");
        sentenceTokens = pSpace.split((CharSequence)sentence);
        StringBuilder sb2 = new StringBuilder();
        for (int i = sentenceTokens.length - 1; i > 0; --i) {
            sb2.insert(0, sentenceTokens[i] + " ");
            if (!sentenceTokens[i].trim().startsWith("[POST]")) continue;
            for (int j = i - 1; !(j <= 0 || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POSP]")); --j) {
                if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[NEGATED]");
            }
        }
        sentence = sb2.toString();
        if (negPoss) {
            pSpace = Pattern.compile("[\\s+]");
            sentenceTokens = pSpace.split((CharSequence)sentence);
            StringBuilder sb3 = new StringBuilder();
            for (int i = 0; i < sentenceTokens.length; ++i) {
                sb3.append(" " + sentenceTokens[i].trim());
                if (!sentenceTokens[i].trim().startsWith("[PREP]")) continue;
                for (int j = i + 1; !(j >= sentenceTokens.length || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[POST]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[POSP]")); ++j) {
                    if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                    sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[POSSIBLE]");
                }
            }
            sentence = sb3.toString();
            pSpace = Pattern.compile("[\\s+]");
            sentenceTokens = pSpace.split((CharSequence)sentence);
            StringBuilder sb4 = new StringBuilder();
            for (int i = sentenceTokens.length - 1; i > 0; --i) {
                sb4.insert(0, sentenceTokens[i] + " ");
                if (!sentenceTokens[i].trim().startsWith("[POSP]")) continue;
                for (int j = i - 1; !(j <= 0 || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POST]")); --j) {
                    if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                    sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[POSSIBLE]");
                }
            }
            sentence = sb4.toString();
        }
        sentence = ((String)sentence).replaceAll(filler, " ");
        sentence = ((String)sentence).substring(0, ((String)sentence).trim().lastIndexOf(46));
        if (((String)(sentence = ((String)sentence).replaceFirst(".", ""))).contains("[PREN]") || ((String)sentence).contains("[PREP]")) {
            int endOffset;
            int startOffset = ((String)sentence).indexOf("[PREN]");
            if (startOffset == -1) {
                startOffset = ((String)sentence).indexOf("[PREP]");
            }
            if ((endOffset = ((String)sentence).indexOf("[CONJ]")) == -1) {
                endOffset = ((String)sentence).indexOf("[PSEU]");
            }
            if (endOffset == -1) {
                endOffset = ((String)sentence).indexOf("[POST]");
            }
            if (endOffset == -1) {
                endOffset = ((String)sentence).indexOf("[POSP]");
            }
            if (endOffset == -1 || endOffset < startOffset) {
                endOffset = ((String)sentence).length() - 1;
            }
            sScope = ((String)sentence).substring(startOffset, endOffset + 1);
        }
        if (((String)sentence).contains("[POST]") || ((String)sentence).contains("[POSP]")) {
            int startOffset;
            int endOffset = ((String)sentence).lastIndexOf("[POST]");
            if (endOffset == -1) {
                endOffset = ((String)sentence).lastIndexOf("[POSP]");
            }
            if ((startOffset = ((String)sentence).lastIndexOf("[CONJ]")) == -1) {
                startOffset = ((String)sentence).lastIndexOf("[PSEU]");
            }
            if (startOffset == -1) {
                startOffset = ((String)sentence).lastIndexOf("[PREN]");
            }
            if (startOffset == -1) {
                startOffset = ((String)sentence).lastIndexOf("[PREP]");
            }
            if (startOffset == -1) {
                startOffset = 0;
            }
            sScope = ((String)sentence).substring(startOffset, endOffset);
        }
        sentence = ((String)sentence).contains("[NEGATED]") ? (String)sentence + "\tnegated\t" + sScope : (((String)sentence).contains("[POSSIBLE]") ? (String)sentence + "\tpossible\t" + sScope : (String)sentence + "\taffirmed\t" + sScope);
        this.previousRunScope = sScope;
        sToReturn = sentence;
        return sToReturn;
    }

    public String getPreviousRunScope() {
        return this.previousRunScope;
    }
}

