/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import lingscope.algorithms.AbnerTokenizer;
import lingscope.algorithms.NegexAnnotator;
import lingscope.structures.AnnotatedSentence;

public class NegexCueAnnotator
extends NegexAnnotator {
    public NegexCueAnnotator(String beginTag, String interTag, String otherTag) {
        super(beginTag, interTag, otherTag);
    }

    @Override
    public AnnotatedSentence annotateSentence(String sentence, boolean isTokenized) {
        if (this.negex == null) {
            throw new RuntimeException("Annotator has not been loaded");
        }
        if (!isTokenized) {
            sentence = AbnerTokenizer.splitTermsByPunctuation(sentence);
        }
        String raw = this.negex.getCue(sentence, this.rules, this.beginTag, this.interTag, this.otherTag);
        return new AnnotatedSentence(raw);
    }
}

