/*
 * Decompiled with CFR 0.152.
 */
package lingscope.algorithms;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import lingscope.structures.AnnotatedSentence;

public abstract class Annotator {
    protected String beginTag;
    protected String interTag;
    protected String otherTag;

    public Annotator(String beginTag, String interTag, String otherTag) {
        this.beginTag = beginTag;
        this.interTag = interTag;
        this.otherTag = otherTag;
    }

    public abstract void serializeAnnotator(String var1, String var2);

    public abstract AnnotatedSentence annotateSentence(String var1, boolean var2);

    public void loadAnnotator(String modelFile) {
        try (FileInputStream fis = new FileInputStream(modelFile);){
            this.loadAnnotator(fis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void loadAnnotator(InputStream var1);

    public boolean isTargetNegated(String sentence, boolean isTokenized, String targetPhrase) {
        AnnotatedSentence annotatedSentence = this.annotateSentence(sentence, isTokenized);
        String[] targetPhraseWords = targetPhrase.split("\\s+");
        List<String> words = annotatedSentence.getWords();
        List<Boolean> areNegated = annotatedSentence.getIsAnnotatedTags();
        int index = 0;
        for (String word : words) {
            if (targetPhraseWords[0].equalsIgnoreCase(word)) {
                return areNegated.get(index);
            }
            ++index;
        }
        System.err.println("Phrase not found: " + targetPhrase);
        return false;
    }
}

