/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.multiplier.line;

import de.julielab.jcore.types.Header;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Line Multiplier", description="Splits incoming CAS document texts on line breaks and returns one CAS for each non-blank line.")
public class LineMultiplier
extends JCasMultiplier_ImplBase {
    public static final String PARAM_NUM_LINES = "NumberLinesPerCAS";
    private static final Logger log = LoggerFactory.getLogger(LineMultiplier.class);
    @ConfigurationParameter(name="NumberLinesPerCAS", mandatory=false, defaultValue={"1"}, description="The number of lines that should be put into one cas. Defaults to 1.")
    private int numLinesPerCas;
    private Deque<String> lines = new ArrayDeque<String>();
    private int numLines = 0;
    private int numCases = 0;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.numLinesPerCas = Optional.ofNullable((Integer)aContext.getConfigParameterValue(PARAM_NUM_LINES)).orElse(1);
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        Arrays.stream(aJCas.getDocumentText().split(System.getProperty("line.separator"))).filter(Predicate.not(String::isBlank)).forEach(this.lines::add);
        log.info("Got {} lines", (Object)this.lines.size());
    }

    public AbstractCas next() {
        JCas cas = this.getEmptyJCas();
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        for (int i = 0; i < this.numLinesPerCas && !this.lines.isEmpty(); ++i) {
            sb.append(this.lines.removeFirst() + ls);
            ++this.numLines;
        }
        sb.delete(sb.length() - ls.length(), sb.length());
        cas.setDocumentText(sb.toString());
        Header h = new Header(cas);
        h.setDocId("line" + this.numCases++);
        if (this.numLines % 1000 == 0) {
            log.info("Batch checkpoint: {} lines left", (Object)this.lines.size());
        }
        return cas;
    }

    public boolean hasNext() throws AnalysisEngineProcessException {
        return !this.lines.isEmpty();
    }
}

