/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.likelihoodassignment;

import de.julielab.jcore.types.ConceptMention;
import de.julielab.jcore.types.LikelihoodIndicator;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.utility.JCoReAnnotationIndexMerger;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Likelihood Assignment AE", description="Analysis Engine to assign likelihood indicators to their corresponding entities and events.")
@TypeCapability(inputs={"de.julielab.jcore.types.LikelihoodIndicator"})
public class LikelihoodAssignmentAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_ASSIGNMENT_STRATEGY = "AssignmentStrategy";
    public static final String PARAM_CONCEPT_TYPE_NAME = "ConceptTypeName";
    public static final String STRATEGY_ALL = "all";
    public static final String STRATEGY_NEXT_CONCEPT = "next-concept";
    private static final Logger LOGGER = LoggerFactory.getLogger(LikelihoodAssignmentAnnotator.class);
    @ConfigurationParameter(name="AssignmentStrategy", mandatory=false, defaultValue={"next-concept"}, description="There are two available assignment strategies for likelihood indicators to ConceptMentions, 'all' and 'next-concept'. The first, 'all', assigns the lowest likelihood indicator in a sentence to all ConceptMention in this sentence. The second assigns a likelihood indicator only to the directly following ConceptMention in the same sentence. The latter strategy fares a bit better in evaluations carried out for the publication of this approach. Defaults to 'next-concept'.")
    private String assignmentStrategy;
    @ConfigurationParameter(name="ConceptTypeName", mandatory=false, defaultValue={"de.julielab.jcore.types.ConceptMention"}, description="The qualified UIMA type name for the concept annotation for which likelihood assignment should be performed. Must be a subclass of de.julielab.jcore.types.ConceptMention. Defaults to de.julielab.jcore.types.ConceptMention.")
    private String conceptTypeName;
    private TreeMap<Integer, Integer> sentMap;
    private TreeMap<Integer, ArrayList<ConceptMention>> conceptMap;
    private TreeMap<Integer, LikelihoodIndicator> likelihoodMap;
    private HashMap<String, Integer> likelihoodValueMap;
    private ConceptMention conceptTypeTemplate;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.assignmentStrategy = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_ASSIGNMENT_STRATEGY)).orElse(STRATEGY_NEXT_CONCEPT);
        this.conceptTypeName = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_CONCEPT_TYPE_NAME)).orElse(ConceptMention.class.getCanonicalName());
        this.likelihoodValueMap = new HashMap();
        this.likelihoodValueMap.put("negation", 1);
        this.likelihoodValueMap.put("low", 2);
        this.likelihoodValueMap.put("investigation", 3);
        this.likelihoodValueMap.put("moderate", 4);
        this.likelihoodValueMap.put("high", 5);
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        if (this.conceptTypeTemplate == null) {
            try {
                this.conceptTypeTemplate = (ConceptMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)this.conceptTypeName);
            }
            catch (Exception e) {
                LOGGER.error("Could not obtain the specified concept UIMA type with name " + this.conceptTypeName + ".", (Throwable)e);
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
        if (this.assignmentStrategy.equalsIgnoreCase(STRATEGY_NEXT_CONCEPT)) {
            this.assignLikelihoodToNextConceptMention(aJCas);
        } else if (this.assignmentStrategy.equalsIgnoreCase(STRATEGY_ALL)) {
            this.assignLikelihood(aJCas);
        } else {
            throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("The AssignmentStrategy parameter requires one of two values, all or next-concept but was set to " + this.assignmentStrategy + "."));
        }
    }

    private void assignLikelihoodToNextConceptMention(JCas aJCas) throws AnalysisEngineProcessException {
        LikelihoodIndicator assertionIndicator = new LikelihoodIndicator(aJCas);
        assertionIndicator.setLikelihood("assertion");
        assertionIndicator.setComponentId(((Object)((Object)this)).getClass().getName());
        assertionIndicator.addToIndexes();
        for (Sentence sentence : aJCas.getAnnotationIndex(Sentence.type)) {
            JCoReAnnotationIndexMerger merger;
            try {
                merger = new JCoReAnnotationIndexMerger(Set.of(JCasUtil.getAnnotationType((JCas)aJCas, this.conceptTypeTemplate.getClass()), JCasUtil.getAnnotationType((JCas)aJCas, LikelihoodIndicator.class)), true, (AnnotationFS)sentence, aJCas);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Could not create JCoReAnnotationIndexMerger", (Throwable)e);
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            LikelihoodIndicator previousLikelihood = null;
            boolean previousLikelihoodConsumed = false;
            int lastAssignedCmBegin = 0;
            int lastAssignedCmEnd = 0;
            while (merger.incrementAnnotation()) {
                Annotation annotation = (Annotation)merger.getAnnotation();
                ConceptMention cm = null;
                if (this.conceptTypeTemplate.getClass().isAssignableFrom(annotation.getClass())) {
                    cm = (ConceptMention)annotation;
                    cm.setLikelihood(assertionIndicator);
                }
                if (cm != null && previousLikelihood != null && (!previousLikelihoodConsumed || lastAssignedCmBegin == cm.getBegin() && lastAssignedCmEnd == cm.getEnd())) {
                    cm.setLikelihood(previousLikelihood);
                    previousLikelihoodConsumed = true;
                    lastAssignedCmBegin = cm.getBegin();
                    lastAssignedCmEnd = cm.getEnd();
                }
                if (!(annotation instanceof LikelihoodIndicator)) continue;
                previousLikelihood = (LikelihoodIndicator)annotation;
                previousLikelihoodConsumed = false;
            }
        }
    }

    private void assignLikelihood(JCas aJCas) {
        this.buildTreeMaps(aJCas);
        LikelihoodIndicator assertionIndicator = new LikelihoodIndicator(aJCas);
        assertionIndicator.setLikelihood("assertion");
        assertionIndicator.setComponentId(((Object)((Object)this)).getClass().getName());
        assertionIndicator.addToIndexes();
        for (int sentBegin : this.sentMap.keySet()) {
            int firstConceptBegin;
            int sentEnd = this.sentMap.get(sentBegin);
            boolean sentHasLikelihood = false;
            boolean multipleLikelihood = false;
            Integer firstLikelihoodBegin = 0;
            Integer lastLikelihoodBegin = 0;
            firstLikelihoodBegin = this.likelihoodMap.ceilingKey(sentBegin);
            if (firstLikelihoodBegin != null) {
                sentHasLikelihood = firstLikelihoodBegin <= sentEnd;
            }
            if (sentHasLikelihood) {
                lastLikelihoodBegin = this.likelihoodMap.floorKey(sentEnd);
                multipleLikelihood = firstLikelihoodBegin != lastLikelihoodBegin;
            }
            LikelihoodIndicator assignedLikelihood = null;
            if (sentHasLikelihood) {
                if (multipleLikelihood) {
                    NavigableMap<Integer, LikelihoodIndicator> likelihoodSubMap = this.likelihoodMap.subMap(firstLikelihoodBegin, true, lastLikelihoodBegin, true);
                    int currentLikelihoodValue = 100;
                    Iterator iterator = likelihoodSubMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        LikelihoodIndicator likelihood = (LikelihoodIndicator)likelihoodSubMap.get(i);
                        String likelihoodCat = likelihood.getLikelihood();
                        int likelihoodValue = this.likelihoodValueMap.get(likelihoodCat);
                        if (likelihoodValue >= currentLikelihoodValue) continue;
                        assignedLikelihood = likelihood;
                        currentLikelihoodValue = likelihoodValue;
                    }
                } else {
                    LikelihoodIndicator likelihood;
                    assignedLikelihood = likelihood = this.likelihoodMap.get(firstLikelihoodBegin);
                }
            } else {
                assignedLikelihood = assertionIndicator;
            }
            if (this.conceptMap.ceilingKey(sentBegin) == null || (firstConceptBegin = this.conceptMap.ceilingKey(sentBegin).intValue()) > sentEnd) continue;
            int lastConceptBegin = this.conceptMap.floorKey(sentEnd);
            NavigableMap<Integer, ArrayList<ConceptMention>> conceptSubMap = this.conceptMap.subMap(firstConceptBegin, true, lastConceptBegin, true);
            Iterator iterator = conceptSubMap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ArrayList conceptList = (ArrayList)conceptSubMap.get(i);
                for (ConceptMention concept : conceptList) {
                    concept.setLikelihood(assignedLikelihood);
                }
            }
        }
    }

    public void buildTreeMaps(JCas aJCas) {
        FSIterator sentIt = aJCas.getAnnotationIndex(Sentence.type).iterator();
        FSIterator conceptIt = aJCas.getAnnotationIndex(ConceptMention.type).iterator();
        FSIterator likelihoodIt = aJCas.getAnnotationIndex(LikelihoodIndicator.type).iterator();
        this.sentMap = new TreeMap();
        while (sentIt.hasNext()) {
            Sentence sent = (Sentence)sentIt.next();
            int sentBegin = sent.getBegin();
            int sentEnd = sent.getEnd();
            this.sentMap.put(sentBegin, sentEnd);
        }
        this.conceptMap = new TreeMap();
        while (conceptIt.hasNext()) {
            ArrayList<Object> conceptList;
            ConceptMention concept = (ConceptMention)conceptIt.next();
            int conceptBegin = concept.getBegin();
            if (this.conceptMap.containsKey(conceptBegin)) {
                conceptList = this.conceptMap.get(conceptBegin);
                conceptList.add(concept);
                this.conceptMap.put(conceptBegin, conceptList);
                continue;
            }
            conceptList = new ArrayList<ConceptMention>();
            conceptList.add(concept);
            this.conceptMap.put(conceptBegin, conceptList);
        }
        this.likelihoodMap = new TreeMap();
        while (likelihoodIt.hasNext()) {
            LikelihoodIndicator likelihood = (LikelihoodIndicator)likelihoodIt.next();
            int likelihoodBegin = likelihood.getBegin();
            this.likelihoodMap.put(likelihoodBegin, likelihood);
        }
    }
}

