/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.likelihoodassignment;

import de.julielab.jcore.types.ConceptMention;
import de.julielab.jcore.types.LikelihoodIndicator;
import de.julielab.jcore.types.Sentence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Likelihood Assignment AE", description="Analysis Engine to assign likelihood indicators to their corresponding entities and events.")
@TypeCapability(inputs={"de.julielab.jcore.types.LikelihoodIndicator"})
public class LikelihoodAssignmentAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LikelihoodAssignmentAnnotator.class);
    private TreeMap<Integer, Integer> sentMap;
    private TreeMap<Integer, ArrayList<ConceptMention>> conceptMap;
    private TreeMap<Integer, LikelihoodIndicator> likelihoodMap;
    private HashMap<String, Integer> likelihoodValueMap;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.likelihoodValueMap = new HashMap();
        this.likelihoodValueMap.put("negation", 1);
        this.likelihoodValueMap.put("low", 2);
        this.likelihoodValueMap.put("investigation", 3);
        this.likelihoodValueMap.put("moderate", 4);
        this.likelihoodValueMap.put("high", 5);
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.assignLikelihood(aJCas);
    }

    private void assignLikelihood(JCas aJCas) {
        this.buildTreeMaps(aJCas);
        LikelihoodIndicator assertionIndicator = new LikelihoodIndicator(aJCas);
        assertionIndicator.setLikelihood("assertion");
        assertionIndicator.setComponentId(((Object)((Object)this)).getClass().getName());
        assertionIndicator.addToIndexes();
        for (int sentBegin : this.sentMap.keySet()) {
            int firstConceptBegin;
            int sentEnd = this.sentMap.get(sentBegin);
            boolean sentHasLikelihood = false;
            boolean multipleLikelihood = false;
            Integer firstLikelihoodBegin = 0;
            Integer lastLikelihoodBegin = 0;
            firstLikelihoodBegin = this.likelihoodMap.ceilingKey(sentBegin);
            if (firstLikelihoodBegin != null) {
                sentHasLikelihood = firstLikelihoodBegin <= sentEnd;
            }
            if (sentHasLikelihood) {
                lastLikelihoodBegin = this.likelihoodMap.floorKey(sentEnd);
                multipleLikelihood = firstLikelihoodBegin != lastLikelihoodBegin;
            }
            LikelihoodIndicator assignedLikelihood = null;
            if (sentHasLikelihood) {
                multipleLikelihood = true;
                if (true) {
                    NavigableMap<Integer, LikelihoodIndicator> likelihoodSubMap = this.likelihoodMap.subMap(firstLikelihoodBegin, true, lastLikelihoodBegin, true);
                    int currentLikelihoodValue = 100;
                    Iterator iterator = likelihoodSubMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        LikelihoodIndicator likelihood = (LikelihoodIndicator)likelihoodSubMap.get(i);
                        String likelihoodCat = likelihood.getLikelihood();
                        int likelihoodValue = this.likelihoodValueMap.get(likelihoodCat);
                        if (likelihoodValue >= currentLikelihoodValue) continue;
                        assignedLikelihood = likelihood;
                        currentLikelihoodValue = likelihoodValue;
                    }
                } else {
                    LikelihoodIndicator likelihood;
                    assignedLikelihood = likelihood = this.likelihoodMap.get(firstLikelihoodBegin);
                }
            } else {
                assignedLikelihood = assertionIndicator;
            }
            if (this.conceptMap.ceilingKey(sentBegin) == null || (firstConceptBegin = this.conceptMap.ceilingKey(sentBegin).intValue()) > sentEnd) continue;
            int lastConceptBegin = this.conceptMap.floorKey(sentEnd);
            NavigableMap<Integer, ArrayList<ConceptMention>> conceptSubMap = this.conceptMap.subMap(firstConceptBegin, true, lastConceptBegin, true);
            Iterator iterator = conceptSubMap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ArrayList conceptList = (ArrayList)conceptSubMap.get(i);
                for (ConceptMention concept : conceptList) {
                    concept.setLikelihood(assignedLikelihood);
                }
            }
        }
    }

    public void buildTreeMaps(JCas aJCas) {
        FSIterator sentIt = aJCas.getAnnotationIndex(Sentence.type).iterator();
        FSIterator conceptIt = aJCas.getAnnotationIndex(ConceptMention.type).iterator();
        FSIterator likelihoodIt = aJCas.getAnnotationIndex(LikelihoodIndicator.type).iterator();
        this.sentMap = new TreeMap();
        while (sentIt.hasNext()) {
            Sentence sent = (Sentence)sentIt.next();
            int sentBegin = sent.getBegin();
            int sentEnd = sent.getEnd();
            this.sentMap.put(sentBegin, sentEnd);
        }
        this.conceptMap = new TreeMap();
        while (conceptIt.hasNext()) {
            ArrayList<Object> conceptList;
            ConceptMention concept = (ConceptMention)conceptIt.next();
            int conceptBegin = concept.getBegin();
            if (this.conceptMap.containsKey(conceptBegin)) {
                conceptList = this.conceptMap.get(conceptBegin);
                conceptList.add(concept);
                this.conceptMap.put(conceptBegin, conceptList);
                continue;
            }
            conceptList = new ArrayList<ConceptMention>();
            conceptList.add(concept);
            this.conceptMap.put(conceptBegin, conceptList);
        }
        this.likelihoodMap = new TreeMap();
        while (likelihoodIt.hasNext()) {
            LikelihoodIndicator likelihood = (LikelihoodIndicator)likelihoodIt.next();
            int likelihoodBegin = likelihood.getBegin();
            this.likelihoodMap.put(likelihoodBegin, likelihood);
        }
    }
}

