/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.entityevaluator;

import de.julielab.jcore.consumer.entityevaluator.EntityEvaluatorConsumer;
import de.julielab.jcore.utility.JCoReFeaturePath;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.cas.TOP;

public class FeatureValueFilter {
    private static final Pattern fullFilterDefinitionFormat = Pattern.compile("(.+:)?\\/(([^=]+=.[^=;]*;?)+)");
    private Matcher mfull = fullFilterDefinitionFormat.matcher("");
    protected PathValuePair globalFeaturePath;
    protected Set<Type> types;
    protected PathValuePair pathValuePair;

    public FeatureValueFilter(String columnDefinition, String typePrefix, TypeSystem ts) {
        this();
        this.parseAndAddDefinition(columnDefinition, typePrefix, ts);
    }

    public FeatureValueFilter() {
    }

    public void parseAndAddDefinition(String filterDefinition, String typePrefix, TypeSystem ts) {
        if (!this.mfull.reset(filterDefinition).matches()) {
            throw new IllegalArgumentException("The line does not obey the column definition syntax: " + filterDefinition);
        }
        if (filterDefinition.contains(":")) {
            String[] colonSplit = filterDefinition.split(":");
            this.types = Stream.of(colonSplit[0].split("\\s*,\\s*")).map(typeName -> EntityEvaluatorConsumer.findType(typeName, typePrefix, ts)).collect(Collectors.toSet());
            this.pathValuePair = new PathValuePair(colonSplit[1].split("="));
        } else {
            this.types = Collections.emptySet();
            this.pathValuePair = new PathValuePair(filterDefinition.split("="));
        }
    }

    public boolean contradictsFeatureFilter(TOP a) {
        Type type = a.getType();
        if (!this.types.contains(type) && !this.types.isEmpty()) {
            return false;
        }
        String fpValue = this.pathValuePair.fp.getValueAsString((FeatureStructure)a);
        return !fpValue.equals(this.pathValuePair.targetValue);
    }

    public static class PathValuePair {
        public JCoReFeaturePath fp;
        public String targetValue;

        public PathValuePair(String[] split) {
            try {
                this.fp = new JCoReFeaturePath();
                this.fp.initialize(split[0]);
                this.targetValue = split[1];
            }
            catch (CASException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

