/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.entityevaluator;

import de.julielab.jcore.consumer.entityevaluator.Column;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceIdColumn
extends Column {
    private static final Logger log = LoggerFactory.getLogger(SentenceIdColumn.class);
    private JCoReTreeMapAnnotationIndex<Long, ? extends Annotation> sentenceIndex;
    private Map<Annotation, String> sentenceIds = new HashMap<Annotation, String>();

    public JCoReTreeMapAnnotationIndex<Long, ? extends Annotation> getSentenceIndex() {
        return this.sentenceIndex;
    }

    public SentenceIdColumn(String documentId, Column c, JCoReTreeMapAnnotationIndex<Long, ? extends Annotation> sentenceIndex) {
        super(c);
        this.sentenceIndex = sentenceIndex;
        if (!sentenceIndex.getIndex().isEmpty()) {
            int sentenceNumber = 0;
            for (Annotation s : sentenceIndex.getIndex().values().stream().flatMap(sentences -> sentences.stream()).collect(Collectors.toList())) {
                String sentenceId = this.getValue((TOP)s);
                if (sentenceId == null) {
                    if (documentId == null) {
                        throw new IllegalArgumentException("At least one sentence does not have an ID, but the sentence ID column was added for output columns and the document ID column was not defined. But it is required to create a unique sentence ID.");
                    }
                    sentenceId = documentId + ":" + sentenceNumber++;
                }
                this.sentenceIds.put(s, sentenceId);
            }
        }
    }

    @Override
    public String getValue(TOP a) {
        String value = null;
        Annotation sentence = this.sentenceIndex.get((Annotation)a);
        if (sentence != null) {
            value = this.sentenceIds.get(sentence);
        } else {
            log.warn("There was no sentence found covering the annotation " + a);
        }
        return value;
    }
}

