/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.entityevaluator;

import de.julielab.jcore.consumer.entityevaluator.Column;
import de.julielab.jcore.consumer.entityevaluator.EntityEvaluatorConsumer;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class OffsetsColumn
extends Column {
    private EntityEvaluatorConsumer.OffsetMode offsetMode;
    private JCoReTreeMapAnnotationIndex<Long, ? extends Annotation> sentenceIndex;
    private EntityEvaluatorConsumer.OffsetScope offsetScope;
    private Map<Annotation, NavigableMap<Integer, Integer>> numWsMaps;
    private NavigableMap<Integer, Integer> documentNumWsMap;

    public OffsetsColumn(NavigableMap<Integer, Integer> numWsMap, EntityEvaluatorConsumer.OffsetMode offsetMode) {
        this.documentNumWsMap = numWsMap;
        this.offsetMode = offsetMode;
        this.offsetScope = EntityEvaluatorConsumer.OffsetScope.Document;
        this.numWsMaps = new HashMap<Annotation, NavigableMap<Integer, Integer>>();
    }

    public OffsetsColumn(JCoReTreeMapAnnotationIndex<Long, ? extends Annotation> sentenceIndex, EntityEvaluatorConsumer.OffsetMode offsetMode) {
        this.sentenceIndex = sentenceIndex;
        this.offsetMode = offsetMode;
        this.offsetScope = EntityEvaluatorConsumer.OffsetScope.Sentence;
        this.numWsMaps = new HashMap<Annotation, NavigableMap<Integer, Integer>>();
    }

    public OffsetsColumn(EntityEvaluatorConsumer.OffsetMode offsetMode) {
        this.offsetMode = offsetMode;
        this.offsetScope = EntityEvaluatorConsumer.OffsetScope.Document;
        this.numWsMaps = new HashMap<Annotation, NavigableMap<Integer, Integer>>();
    }

    @Override
    public String getValue(TOP a) {
        Annotation an = (Annotation)a;
        NavigableMap<Integer, Integer> numWsMap = this.documentNumWsMap;
        int annotationOffset = 0;
        if (this.offsetScope == EntityEvaluatorConsumer.OffsetScope.Sentence) {
            Annotation s = this.sentenceIndex.get(an);
            if (this.offsetMode == EntityEvaluatorConsumer.OffsetMode.NonWsCharacters) {
                numWsMap = this.getNumWsMapForSentence(s);
            }
            annotationOffset = s.getBegin();
        }
        return this.getOffsets(an, numWsMap, annotationOffset);
    }

    private NavigableMap<Integer, Integer> getNumWsMapForSentence(Annotation s) {
        NavigableMap<Integer, Integer> numWsMap = this.numWsMaps.get(s);
        if (numWsMap == null) {
            numWsMap = EntityEvaluatorConsumer.createNumWsMap(s.getCoveredText());
            this.numWsMaps.put(s, numWsMap);
        }
        return numWsMap;
    }

    private String getOffsets(Annotation an, NavigableMap<Integer, Integer> numWsMap, int annotationOffset) {
        int endOffset;
        int beginOffset;
        switch (this.offsetMode) {
            case CharacterSpan: {
                beginOffset = an.getBegin() - annotationOffset;
                endOffset = an.getEnd() - annotationOffset;
                break;
            }
            case NonWsCharacters: {
                beginOffset = an.getBegin() - annotationOffset - numWsMap.floorEntry(an.getBegin()).getValue();
                endOffset = an.getEnd() - annotationOffset - numWsMap.floorEntry(an.getEnd()).getValue() - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Offset mode \"" + (Object)((Object)this.offsetMode) + "\" is currently unsupported.");
            }
        }
        String begin = String.valueOf(beginOffset);
        String end = String.valueOf(endOffset);
        return begin + "\t" + end;
    }

    @Override
    public void reset() {
        this.numWsMaps.clear();
    }
}

