/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.entityevaluator;

import de.julielab.jcore.consumer.entityevaluator.EntityEvaluatorConsumer;
import de.julielab.jcore.utility.JCoReFeaturePath;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.cas.TOP;

public class Column {
    private static final Pattern fullColumnDefinitionFormat = Pattern.compile(".+:(([^=]+=.[^=;]*;?)+|\\/[^;,=]+)");
    private static final Pattern typeDefinitionFormat = Pattern.compile("([^:;]+=[^;]+|\\/:?[^;]+)");
    private static final Pattern typeDefinitionElementsPattern = Pattern.compile("([^,=]+)");
    protected String name;
    protected Map<Type, JCoReFeaturePath> featurePathMap;
    protected JCoReFeaturePath globalFeaturePath;
    private Matcher melements;
    private Matcher mfull = fullColumnDefinitionFormat.matcher("");
    private Matcher mtypes = typeDefinitionFormat.matcher("");

    public String toString() {
        return "Column [name=" + this.name + ", featurePathMap=" + this.featurePathMap + "]";
    }

    public Column(Column other) {
        this();
        this.name = other.name;
        this.featurePathMap = other.featurePathMap;
    }

    public Column(String columnDefinition, String typePrefix, TypeSystem ts) throws CASException {
        this();
        this.parseAndAddDefinition(columnDefinition, typePrefix, ts);
    }

    public Column() {
        this.melements = typeDefinitionElementsPattern.matcher("");
        this.featurePathMap = new LinkedHashMap<Type, JCoReFeaturePath>();
    }

    public String getName() {
        return this.name;
    }

    public void parseAndAddDefinition(String columnDefinition, String typePrefix, TypeSystem ts) throws CASException {
        if (!this.mfull.reset(columnDefinition).matches()) {
            throw new IllegalArgumentException("The line does not obey the column definition syntax: " + columnDefinition);
        }
        this.name = columnDefinition.split(":", 2)[0];
        this.mtypes.reset(columnDefinition);
        while (this.mtypes.find()) {
            String group = this.mtypes.group();
            this.melements.reset(group);
            ArrayList<String> elements = new ArrayList<String>();
            while (this.melements.find()) {
                elements.add(this.melements.group());
            }
            if (elements.size() > 1) {
                for (int i = 0; i < elements.size(); ++i) {
                    String element = (String)elements.get(i);
                    if (i >= elements.size() - 1) continue;
                    String typeName = element.trim();
                    Type type = EntityEvaluatorConsumer.findType(typeName, typePrefix, ts);
                    JCoReFeaturePath fp = new JCoReFeaturePath();
                    fp.initialize(((String)elements.get(elements.size() - 1)).trim());
                    this.featurePathMap.put(type, fp);
                }
                continue;
            }
            this.globalFeaturePath = new JCoReFeaturePath();
            this.globalFeaturePath.initialize((String)elements.get(0));
        }
    }

    public Set<Type> getTypes() {
        return this.featurePathMap.keySet();
    }

    public Type getSingleType() {
        if (this.featurePathMap.size() > 1) {
            throw new IllegalStateException("The column " + this.name + " has more than one type");
        }
        return (Type)this.featurePathMap.keySet().stream().findFirst().get();
    }

    public String getValue(TOP a) {
        String value = null;
        JCoReFeaturePath fp = this.getMostSpecificApplicableFeaturePath(a.getType(), a.getCAS().getTypeSystem());
        if (fp != null) {
            value = fp.getValueAsString((FeatureStructure)a);
        } else if (this.globalFeaturePath != null) {
            value = this.globalFeaturePath.getValueAsString((FeatureStructure)a);
        }
        return value;
    }

    private JCoReFeaturePath getMostSpecificApplicableFeaturePath(Type type, TypeSystem ts) {
        Type ret = type;
        while (this.featurePathMap.get(ret) == null && ret != null) {
            ret = ts.getParent(ret);
        }
        if (this.featurePathMap.containsKey(ret)) {
            this.featurePathMap.put(type, this.featurePathMap.get(ret));
        }
        return this.featurePathMap.get(type);
    }

    public void reset() {
    }
}

