/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import org.apache.uima.util.Progress;

public class ProgressImpl
implements Progress,
Cloneable {
    private static final long serialVersionUID = -1436588781274530622L;
    private String mUnitType = "bytes";
    private long mCompleted;
    private long mTotal;
    private boolean mApproximate;

    public ProgressImpl(int aCompleted, int aTotal, String aUnit, boolean aApproximate) {
        this.mUnitType = aUnit;
        this.mCompleted = aCompleted;
        this.mTotal = aTotal;
        this.mApproximate = aApproximate;
    }

    public ProgressImpl(int aCompleted, int aTotal, String aUnit) {
        this(aCompleted, aTotal, aUnit, false);
    }

    @Override
    public long getCompleted() {
        return this.mCompleted;
    }

    @Override
    public long getTotal() {
        return this.mTotal;
    }

    @Override
    public String getUnit() {
        return this.mUnitType;
    }

    public void setCompleted(int aCompleted) {
        this.mCompleted = aCompleted;
    }

    public void setTotal(int aTotal) {
        this.mTotal = aTotal;
    }

    @Override
    public boolean isApproximate() {
        return this.mApproximate;
    }

    public void increment(int aIncrement) {
        this.mCompleted += (long)aIncrement;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getCompleted());
        if (this.getTotal() >= 0L) {
            buf.append(" of ").append(this.getTotal());
        }
        buf.append(" ").append(this.getUnit());
        if (this.isApproximate()) {
            buf.append(" (approximate)");
        }
        return buf.toString();
    }
}

