/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProcessUtil {

    public static class Runner
    implements Runnable {
        private static final String DEF_PROC_NAME = "Process_";
        private static int __processNumber = 0;
        private Process _process;
        private String _pName;
        private Thread _errThread;
        private Thread _outThread;
        private StringWriter _stdOut;
        private StringWriter _stdErr;
        private int _exitCode = Integer.MAX_VALUE;
        private boolean _printToConsole = true;
        private List<StdStreamListener> _listeners = new ArrayList<StdStreamListener>();

        public Runner(Process aProcess) {
            this(aProcess, null);
        }

        public Runner(Process aProcess, String procName) {
            this(aProcess, procName, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runner(Process aProcess, String procName, boolean printToConsole) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
            }
            this._process = aProcess;
            this._pName = procName != null ? procName : DEF_PROC_NAME + Integer.toString(++__processNumber);
            this._errThread = new Thread((Runnable)this, "ERR@Runner");
            this._outThread = new Thread((Runnable)this, "OUT@Runner");
            this._stdOut = new StringWriter();
            this._stdErr = new StringWriter();
            this._printToConsole = printToConsole;
            this.start();
        }

        public synchronized void addStreamListener(StdStreamListener listener) {
            if (!this._listeners.contains(listener)) {
                String outMsg;
                String errMsg = this._stdErr.toString();
                if (errMsg.length() > 0) {
                    listener.errMsgPrinted(errMsg);
                }
                if ((outMsg = this._stdOut.toString()).length() > 0) {
                    listener.outMsgPrinted(outMsg);
                }
                this._listeners.add(listener);
            }
        }

        public synchronized int getExitCode() {
            return this._exitCode;
        }

        public synchronized String getErrOutput() {
            return this._stdErr.toString();
        }

        public Process getProcess() {
            return this._process;
        }

        public synchronized String getStdOutput() {
            return this._stdOut.toString();
        }

        public synchronized void removeListener(StdStreamListener listener) {
            this._listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            String threadId = threadName.substring(0, 3);
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                reader = threadId.equals("ERR") ? new BufferedReader(new InputStreamReader(this._process.getErrorStream())) : new BufferedReader(new InputStreamReader(this._process.getInputStream()));
                StringWriter sWriter = threadId.equals("ERR") ? this._stdErr : this._stdOut;
                writer = new PrintWriter(sWriter);
                PrintStream console = threadId.equals("ERR") ? System.err : System.out;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (this._printToConsole) {
                        console.println("[" + this._pName + ":" + threadId + "] " + line);
                    }
                    Runner runner = this;
                    synchronized (runner) {
                        int sIndex = sWriter.getBuffer().length();
                        writer.println(line);
                        String message = sWriter.getBuffer().substring(sIndex);
                        Iterator<StdStreamListener> list = this._listeners.iterator();
                        while (message.length() > 0 && list.hasNext()) {
                            StdStreamListener listener = list.next();
                            if (threadId.equals("ERR")) {
                                listener.errMsgPrinted(message);
                                continue;
                            }
                            listener.outMsgPrinted(message);
                        }
                    }
                }
                int rc = this._process.waitFor();
                this.setExitCode(rc);
                if (this._printToConsole) {
                    System.out.println("[" + this._pName + " " + threadName + "]: completed (rc = " + rc + ")");
                }
            }
            catch (Throwable err) {
                if (this._printToConsole) {
                    System.err.println("[" + this._pName + " " + threadName + "]: terminated - " + err.toString());
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {}
                }
            }
            Runner runner = this;
            synchronized (runner) {
                this.notifyAll();
            }
        }

        private synchronized void setExitCode(int exitCode) {
            this._exitCode = exitCode;
        }

        private void start() {
            this._errThread.start();
            this._outThread.start();
        }

        public int waitFor() {
            return this.waitFor(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitFor(long timeout) {
            Runner runner = this;
            synchronized (runner) {
                if (this.getExitCode() == Integer.MAX_VALUE) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            return this.getExitCode();
        }
    }

    public static interface StdStreamListener {
        public void errMsgPrinted(String var1);

        public void outMsgPrinted(String var1);
    }
}

