/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class UIMAClassLoader
extends URLClassLoader {
    public static final boolean SUPPORTS_PARALLEL_LOADING;

    public static URL[] transformClasspath(String classpath) throws MalformedURLException {
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<String> pathList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            pathList.add(tok.nextToken());
        }
        int max = pathList.size();
        URL[] urlArray = new URL[max];
        for (int i = 0; i < max; ++i) {
            urlArray[i] = new File((String)pathList.get(i)).toURI().toURL();
        }
        return urlArray;
    }

    public UIMAClassLoader(String classpath) throws MalformedURLException {
        super(UIMAClassLoader.transformClasspath(classpath));
    }

    public UIMAClassLoader(URL[] classpath) {
        super(classpath);
    }

    public UIMAClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
    }

    public UIMAClassLoader(String classpath, ClassLoader parent) throws MalformedURLException {
        super(UIMAClassLoader.transformClasspath(classpath), parent);
    }

    public static URLClassLoader newInstance(URL[] urls) {
        throw new UnsupportedOperationException();
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (SUPPORTS_PARALLEL_LOADING) {
            return this.loadClassImpl(name, resolve);
        }
        UIMAClassLoader uIMAClassLoader = this;
        synchronized (uIMAClassLoader) {
            return this.loadClassImpl(name, resolve);
        }
    }

    private Class<?> loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, false);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    static {
        boolean bl = SUPPORTS_PARALLEL_LOADING = (double)Float.parseFloat(System.getProperty("java.version").substring(0, 3)) >= 1.7;
        if (SUPPORTS_PARALLEL_LOADING) {
            try {
                Method m = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                m.setAccessible(true);
                m.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

