/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.uima.internal.util.IntArrayUtils;

public class IntVector
implements Serializable {
    private static final long serialVersionUID = 4829243434421992519L;
    private static final int default_size = 16;
    private static final int default_growth_factor = 2;
    private static final int default_multiplication_limit = 2000000;
    private final int growth_factor;
    private final int multiplication_limit;
    protected int pos = 0;
    protected int[] array = null;

    public IntVector() {
        this(16, 2, 2000000);
    }

    public IntVector(int[] array) {
        if (array == null) {
            array = new int[]{};
        }
        this.pos = array.length;
        this.array = array;
        this.growth_factor = 2;
        this.multiplication_limit = 2000000;
    }

    public IntVector(int capacity) {
        this(capacity, 2, 2000000);
    }

    public IntVector(int capacity, int growth_factor, int multiplication_limit) {
        if (capacity < 0) {
            capacity = 16;
        }
        if (growth_factor < 1) {
            growth_factor = 2;
        }
        if (multiplication_limit < 1) {
            multiplication_limit = 2000000;
        }
        this.growth_factor = growth_factor;
        this.multiplication_limit = multiplication_limit;
        this.array = new int[capacity];
    }

    public void setSize(int size) {
        if (size > 0) {
            this.ensure_size(size);
        }
    }

    public void add(int[] elements) {
        this.add(elements, 0, elements.length);
    }

    public void add(int[] elements, int startpos, int endpos) {
        int len = endpos - startpos;
        int posNow = this.pos;
        this.ensure_size(this.pos + len);
        System.arraycopy(elements, startpos, this.array, posNow, len);
    }

    public void add(int element) {
        int i = this.pos++;
        this.ensure_size(this.pos);
        this.array[i] = element;
    }

    public void add(int index, int element) {
        if (index >= this.pos) {
            this.ensure_size(index + 1);
        } else {
            if (this.array.length <= this.pos) {
                this.ensure_size(this.pos + 1);
            } else {
                ++this.pos;
            }
            System.arraycopy(this.array, index, this.array, index + 1, this.pos - (index + 1));
        }
        this.array[index] = element;
    }

    public void set(int index, int element) {
        if (index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[index] = element;
    }

    public void put(int index, int element) {
        this.ensure_size(index + 1);
        this.array[index] = element;
    }

    public int get(int index) {
        if (index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public int remove(int index) {
        if (index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.pos;
        int retval = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.pos - index);
        return retval;
    }

    public void removeAllElements() {
        this.pos = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        IntVector v = (IntVector)o;
        if (this.size() != v.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] == v.get(i)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.pos;
    }

    public boolean contains(int elem) {
        return this.position(elem) >= 0;
    }

    public int position(int elem) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.array[i] != elem) continue;
            return i;
        }
        return -1;
    }

    public void fill(int value) {
        Arrays.fill(this.array, value);
    }

    public int[] toArray() {
        this.trimToSize();
        return this.array;
    }

    public IntVector sortDedup() {
        int v;
        int cpyfromIndex;
        if (this.pos == 0) {
            return this;
        }
        Arrays.sort(this.array, 0, this.pos);
        int prev = this.array[0];
        int cpytoIndex = 1;
        for (cpyfromIndex = 1; cpyfromIndex < this.pos && (v = this.array[cpyfromIndex]) != prev; ++cpyfromIndex) {
            prev = v;
        }
        cpytoIndex = cpyfromIndex++;
        while (cpyfromIndex < this.pos) {
            if ((v = this.array[cpyfromIndex++]) == prev) continue;
            this.array[cpytoIndex++] = prev = v;
        }
        this.pos = cpytoIndex;
        return this;
    }

    public int[] toArrayCopy() {
        int max = this.size();
        int[] copy = new int[max];
        System.arraycopy(this.array, 0, copy, 0, max);
        return copy;
    }

    public int[] getArray() {
        return this.array;
    }

    public int indexOf(int element) {
        for (int i = 0; i < this.pos; ++i) {
            if (element != this.array[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfOptimizeAscending(int element) {
        int midValue = this.array[this.pos >>> 1];
        if (element > midValue) {
            for (int i = this.pos - 1; i >= 0; --i) {
                if (element != this.array[i]) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.pos; ++i) {
            if (element != this.array[i]) continue;
            return i;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.pos == this.array.length) {
            return;
        }
        int[] new_array = new int[this.pos];
        System.arraycopy(this.array, 0, new_array, 0, this.pos);
        this.array = new_array;
    }

    public IntVector copy() {
        IntVector copy = new IntVector(this.array.length, this.growth_factor, this.multiplication_limit);
        copy.pos = this.pos;
        System.arraycopy(this.array, 0, copy.array, 0, this.pos);
        return copy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.pos; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.array[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensure_size(int req) {
        this.array = IntArrayUtils.ensure_size(this.array, req, this.growth_factor, this.multiplication_limit);
        if (this.pos < req) {
            this.pos = req;
        }
    }

    public int hashCode() {
        if (this.array == null) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.get(i);
        }
        return sum;
    }
}

