/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import java.util.LinkedHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;

public final class DescriptionUtils {
    private DescriptionUtils() {
    }

    public static AnalysisEngineDescription consolidate(AnalysisEngineDescription aDesc) throws ResourceInitializationException, InvalidXMLException {
        AnalysisEngineDescription desc = (AnalysisEngineDescription)aDesc.clone();
        DescriptionUtils.consolidateAggregate(desc, UIMAFramework.newDefaultResourceManager());
        return desc;
    }

    /*
     * WARNING - void declaration
     */
    private static void consolidateAggregate(AnalysisEngineDescription aDesc, ResourceManager aResMgr) throws ResourceInitializationException, InvalidXMLException {
        void var5_9;
        if (aDesc.isPrimitive() || aDesc.getDelegateAnalysisEngineSpecifiers().isEmpty()) {
            return;
        }
        for (ResourceSpecifier delegate : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
            DescriptionUtils.consolidateAggregate((AnalysisEngineDescription)delegate, aResMgr);
        }
        ProcessingResourceMetaData meta = CasCreationUtils.mergeDelegateAnalysisEngineMetaData(aDesc, aResMgr, null, null);
        AnalysisEngineDescription firstDelegate = null;
        for (ResourceSpecifier resourceSpecifier : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
            AnalysisEngineDescription aeDelegate = (AnalysisEngineDescription)resourceSpecifier;
            aeDelegate.getAnalysisEngineMetaData().setTypeSystem(null);
            aeDelegate.getAnalysisEngineMetaData().setTypePriorities(null);
            aeDelegate.getAnalysisEngineMetaData().setFsIndexCollection(null);
            if (firstDelegate != null) continue;
            firstDelegate = aeDelegate;
        }
        firstDelegate.getAnalysisEngineMetaData().setTypeSystem(meta.getTypeSystem());
        aDesc.getAnalysisEngineMetaData().setTypePriorities(meta.getTypePriorities());
        aDesc.getAnalysisEngineMetaData().setFsIndexCollection(meta.getFsIndexCollection());
        LinkedHashMap<String, ExternalResourceDescription> resources = new LinkedHashMap<String, ExternalResourceDescription>();
        for (ResourceSpecifier delegate : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
            AnalysisEngineDescription aeDelegate = (AnalysisEngineDescription)delegate;
            ResourceManagerConfiguration delegateResMgrCfg = aeDelegate.getResourceManagerConfiguration();
            for (ExternalResourceDescription res : delegateResMgrCfg.getExternalResources()) {
                resources.put(res.getName(), res);
            }
            delegateResMgrCfg.setExternalResources(null);
        }
        ResourceManagerConfiguration resourceManagerConfiguration = aDesc.getResourceManagerConfiguration();
        if (resourceManagerConfiguration == null) {
            ResourceManagerConfiguration resourceManagerConfiguration2 = UIMAFramework.getResourceSpecifierFactory().createResourceManagerConfiguration();
            aDesc.setResourceManagerConfiguration(resourceManagerConfiguration2);
        }
        var5_9.setExternalResources(resources.values().toArray(new ExternalResourceDescription[resources.size()]));
    }
}

