/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.ListUtils;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XCASParsingException;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmiCasDeserializer {
    private TypeSystemImpl ts;
    private Map<String, String> xmiNamespaceToUimaNamespaceMap = new HashMap<String, String>();

    public XmiCasDeserializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
    }

    public XmiCasDeserializer(TypeSystem ts) {
        this(ts, null);
    }

    public DefaultHandler getXmiCasHandler(CAS cas) {
        return this.getXmiCasHandler(cas, false);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, null, -1, AllowPreexistingFS.ignore);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, sharedData, -1, AllowPreexistingFS.ignore);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, sharedData, mergePoint, AllowPreexistingFS.ignore);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint, AllowPreexistingFS allow) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, sharedData, mergePoint, allow);
    }

    public static void deserialize(InputStream aStream, CAS aCAS) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, false, null, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, aLenient, null, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, aLenient, aSharedData, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData, int aMergePoint) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData, int aMergePoint, AllowPreexistingFS allowPreexistingFS) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint, allowPreexistingFS);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    private String xmiElementName2uimaTypeName(String nsUri, String localName) throws SAXException {
        String uimaNamespace = this.xmiNamespaceToUimaNamespaceMap.get(nsUri);
        if (uimaNamespace == null) {
            if ("http:///uima/noNamespace.ecore".equals(nsUri)) {
                uimaNamespace = "";
            } else {
                URI uri;
                try {
                    uri = new URI(nsUri);
                }
                catch (URISyntaxException e) {
                    throw new SAXException(e);
                }
                String path = uri.getPath();
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith(".ecore")) {
                    path = path.substring(0, path.length() - 6);
                }
                uimaNamespace = path.replace('/', '.') + '.';
            }
            this.xmiNamespaceToUimaNamespaceMap.put(nsUri, uimaNamespace);
        }
        return uimaNamespace + localName;
    }

    private class XmiCasDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int FEAT_CONTENT_STATE = 3;
        private static final int IGNORING_XMI_ELEMENTS_STATE = 4;
        private static final int REF_FEAT_STATE = 5;
        private static final String unknownXMLSource = "<unknown>";
        private String ID_ATTR_NAME = "xmi:id";
        private Locator locator;
        private CASImpl casBeingFilled;
        private IntVector deserializedFsAddrs;
        private IntVector fsListNodesFromMultivaluedProperties;
        private int state;
        private StringBuffer buffer;
        private int currentAddr;
        private TypeImpl currentType;
        private int currentArrayId;
        private List<String> currentArrayElements;
        private Map<String, List<String>> multiValuedFeatures = new TreeMap<String, List<String>>();
        private int sofaTypeCode;
        private int sofaNumFeatCode;
        private int sofaFeatCode;
        private List<FSIndexRepository> indexRepositories;
        private List<CAS> views;
        private ListUtils listUtils;
        private int[] featureType;
        boolean lenient;
        private int ignoreDepth = 0;
        private Map<String, String> nsPrefixToUriMap = new HashMap<String, String>();
        private XmiSerializationSharedData sharedData;
        private int nextSofaNum;
        private int mergePoint;
        private XmiSerializationSharedData.OotsElementData outOfTypeSystemElement = null;
        private RedBlackTree<Integer> localXmiIdToFsAddrMap = new RedBlackTree();
        AllowPreexistingFS allowPreexistingFS;
        IntVector featsSeen = null;
        boolean disallowedViewMemberEncountered;

        private XmiCasDeserializerHandler(CASImpl aCAS, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint, AllowPreexistingFS allowPreexistingFS) {
            this.casBeingFilled = aCAS.getBaseCAS();
            this.lenient = lenient;
            this.sharedData = sharedData != null ? sharedData : new XmiSerializationSharedData();
            this.mergePoint = mergePoint;
            this.allowPreexistingFS = allowPreexistingFS;
            this.featsSeen = null;
            this.disallowedViewMemberEncountered = false;
            if (mergePoint < 0) {
                this.casBeingFilled.resetNoQuestions();
                this.sharedData.clearIdMap();
                this.nextSofaNum = 2;
            } else {
                this.nextSofaNum = this.casBeingFilled.getBaseSofaCount() + 1;
            }
            this.deserializedFsAddrs = new IntVector();
            this.fsListNodesFromMultivaluedProperties = new IntVector();
            this.buffer = new StringBuffer();
            this.indexRepositories = new ArrayList<FSIndexRepository>();
            this.views = new ArrayList<CAS>();
            this.indexRepositories.add(this.casBeingFilled.getBaseIndexRepository());
            this.indexRepositories.add(this.casBeingFilled.getView("_InitialView").getIndexRepository());
            FSIterator<SofaFS> sofaIter = this.casBeingFilled.getSofaIterator();
            while (sofaIter.hasNext()) {
                SofaFS sofa = (SofaFS)sofaIter.next();
                if (sofa.getSofaRef() == 1) {
                    this.casBeingFilled.registerInitialSofa();
                    continue;
                }
                this.indexRepositories.add(this.casBeingFilled.getSofaIndexRepository(sofa));
            }
            TypeSystemImpl tsOfReceivingCas = this.casBeingFilled.getTypeSystemImpl();
            this.sofaTypeCode = tsOfReceivingCas.ll_getCodeForTypeName("uima.cas.Sofa");
            this.sofaNumFeatCode = tsOfReceivingCas.ll_getCodeForFeatureName("uima.cas.Sofa:sofaNum");
            this.sofaFeatCode = tsOfReceivingCas.ll_getCodeForFeatureName("uima.tcas.Annotation:sofa");
            this.listUtils = new ListUtils(this.casBeingFilled, UIMAFramework.getLogger(XmiCasDeserializer.class), null);
            this.featureType = new int[tsOfReceivingCas.getNumberOfFeatures() + 1];
            Iterator<Feature> it = tsOfReceivingCas.getFeatures();
            while (it.hasNext()) {
                FeatureImpl feat = (FeatureImpl)it.next();
                this.featureType[feat.getCode()] = this.classifyType(tsOfReceivingCas.range(feat.getCode()));
            }
        }

        private final void resetBuffer() {
            this.buffer = new StringBuffer();
        }

        @Override
        public void startDocument() throws SAXException {
            this.state = 0;
        }

        @Override
        public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (attrs != null) {
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            String attrName = attrs.getQName(i);
                            if (!attrName.startsWith("xmlns:")) continue;
                            String prefix = attrName.substring(6);
                            String uri = attrs.getValue(i);
                            this.nsPrefixToUriMap.put(prefix, uri);
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    int idInt;
                    String id;
                    if (qualifiedName.startsWith("xmi")) {
                        this.state = 4;
                        ++this.ignoreDepth;
                        return;
                    }
                    if (this.mergePoint >= 0 && (id = attrs.getValue(this.ID_ATTR_NAME)) != null && (idInt = Integer.parseInt(id)) > 0 && !this.isNewFS(idInt)) {
                        if (this.allowPreexistingFS == AllowPreexistingFS.ignore) {
                            this.state = 4;
                            ++this.ignoreDepth;
                            return;
                        }
                        if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                            CASRuntimeException e = new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", new String[]{this.ID_ATTR_NAME + "=" + id, nameSpaceURI, localName, qualifiedName});
                            throw e;
                        }
                    }
                    if (nameSpaceURI == null || nameSpaceURI.length() == 0) {
                        int colonIndex = qualifiedName.indexOf(58);
                        if (colonIndex != -1) {
                            String prefix = qualifiedName.substring(0, colonIndex);
                            nameSpaceURI = this.nsPrefixToUriMap.get(prefix);
                            if (nameSpaceURI == null) {
                                nameSpaceURI = "http:///" + prefix + ".ecore";
                            }
                            localName = qualifiedName.substring(colonIndex + 1);
                        } else {
                            nameSpaceURI = "http:///uima/noNamespace.ecore";
                        }
                    }
                    this.readFS(nameSpaceURI, localName, qualifiedName, attrs);
                    this.multiValuedFeatures.clear();
                    this.state = 2;
                    break;
                }
                case 2: {
                    String href = attrs.getValue("href");
                    if (href != null && href.startsWith("#")) {
                        if (this.outOfTypeSystemElement != null) {
                            XmlElementName elemName = new XmlElementName(nameSpaceURI, localName, qualifiedName);
                            ArrayList<XmlAttribute> ootsAttrs = new ArrayList<XmlAttribute>();
                            ootsAttrs.add(new XmlAttribute("href", href));
                            XmlElementNameAndContents elemWithContents = new XmlElementNameAndContents(elemName, null, ootsAttrs);
                            this.outOfTypeSystemElement.childElements.add(elemWithContents);
                        } else {
                            List<String> valueList = this.multiValuedFeatures.get(qualifiedName);
                            if (valueList == null) {
                                valueList = new ArrayList<String>();
                                this.multiValuedFeatures.put(qualifiedName, valueList);
                            }
                            valueList.add(href.substring(1));
                        }
                        this.state = 5;
                        break;
                    }
                    this.state = 3;
                    break;
                }
                case 4: {
                    ++this.ignoreDepth;
                    break;
                }
                default: {
                    throw this.createException(1, qualifiedName);
                }
            }
        }

        private void readFS(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            String typeName = XmiCasDeserializer.this.xmiElementName2uimaTypeName(nameSpaceURI, localName);
            this.currentType = (TypeImpl)XmiCasDeserializer.this.ts.getType(typeName);
            if (this.currentType == null) {
                if ("uima.cas.NULL".equals(typeName)) {
                    return;
                }
                if ("uima.cas.View".equals(typeName)) {
                    this.processView(attrs.getValue("sofa"), attrs.getValue("members"));
                    String added = attrs.getValue("added_members");
                    String deleted = attrs.getValue("deleted_members");
                    String reindexed = attrs.getValue("reindexed_members");
                    this.processView(attrs.getValue("sofa"), added, deleted, reindexed);
                    return;
                }
                if (!this.lenient) {
                    throw this.createException(4, typeName);
                }
                this.addToOutOfTypeSystemData(new XmlElementName(nameSpaceURI, localName, qualifiedName), attrs);
                return;
            }
            if (this.casBeingFilled.isArrayType(this.currentType)) {
                String idStr = attrs.getValue(this.ID_ATTR_NAME);
                this.currentArrayId = idStr == null ? -1 : Integer.parseInt(idStr);
                String elements = attrs.getValue("elements");
                if (this.casBeingFilled.isByteArrayType(this.currentType)) {
                    this.createByteArray(elements, this.currentArrayId, 0);
                } else if (elements != null) {
                    String[] parsedElements = this.parseArray(elements);
                    this.currentArrayElements = Arrays.asList(parsedElements);
                } else {
                    this.currentArrayElements = null;
                }
            } else {
                int xmiId;
                String idStr = attrs.getValue(this.ID_ATTR_NAME);
                int n = xmiId = idStr == null ? -1 : Integer.parseInt(idStr);
                if (this.isNewFS(xmiId)) {
                    int addr = this.casBeingFilled.ll_createFS(this.currentType.getCode());
                    this.readFS(addr, attrs);
                } else {
                    if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                        CASRuntimeException e = new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", new String[]{this.ID_ATTR_NAME + "=" + idStr, nameSpaceURI, localName, qualifiedName});
                        throw e;
                    }
                    if (this.allowPreexistingFS == AllowPreexistingFS.allow) {
                        int addr = this.getFsAddrForXmiId(xmiId);
                        this.readFS(addr, attrs);
                    }
                }
            }
        }

        private void processView(String sofa, String membersString) throws SAXParseException {
            if (membersString != null) {
                int sofaNum = 1;
                boolean newview = false;
                if (sofa != null) {
                    int sofaAddr;
                    int sofaXmiId = Integer.parseInt(sofa);
                    newview = this.isNewFS(sofaXmiId);
                    try {
                        sofaAddr = this.getFsAddrForXmiId(sofaXmiId);
                    }
                    catch (NoSuchElementException e) {
                        throw this.createException(12, Integer.toString(sofaXmiId));
                    }
                    sofaNum = this.casBeingFilled.getFeatureValue(sofaAddr, this.sofaNumFeatCode);
                }
                FSIndexRepositoryImpl indexRep = (FSIndexRepositoryImpl)this.indexRepositories.get(sofaNum);
                String[] members = this.parseArray(membersString);
                for (int i = 0; i < members.length; ++i) {
                    int id = Integer.parseInt(members[i]);
                    if (!newview && !this.isNewFS(id)) {
                        if (this.allowPreexistingFS == AllowPreexistingFS.ignore) continue;
                        if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                            this.disallowedViewMemberEncountered = true;
                            continue;
                        }
                    }
                    try {
                        int addr = this.getFsAddrForXmiId(id);
                        indexRep.addFS(addr);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        if (!this.lenient) {
                            throw this.createException(12, Integer.toString(id));
                        }
                        this.sharedData.addOutOfTypeSystemViewMember(sofa, members[i]);
                    }
                }
            }
        }

        private void processView(String sofa, String addmembersString, String delmemberString, String reindexmemberString) throws SAXParseException {
            if (addmembersString != null) {
                this.processView(sofa, addmembersString);
            }
            int sofaNum = 1;
            FSIndexRepositoryImpl indexRep = null;
            if (delmemberString != null || reindexmemberString != null) {
                int id;
                int i;
                if (sofa != null) {
                    int sofaXmiId = Integer.parseInt(sofa);
                    int sofaAddr = this.getFsAddrForXmiId(sofaXmiId);
                    sofaNum = this.casBeingFilled.getFeatureValue(sofaAddr, this.sofaNumFeatCode);
                }
                indexRep = (FSIndexRepositoryImpl)this.indexRepositories.get(sofaNum);
                if (delmemberString != null) {
                    String[] members = this.parseArray(delmemberString);
                    for (i = 0; i < members.length; ++i) {
                        id = Integer.parseInt(members[i]);
                        if (!this.isNewFS(id)) {
                            if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                                this.disallowedViewMemberEncountered = true;
                                continue;
                            }
                            if (this.allowPreexistingFS == AllowPreexistingFS.ignore) continue;
                        }
                        try {
                            int addr = this.getFsAddrForXmiId(id);
                            indexRep.removeFS(addr);
                            continue;
                        }
                        catch (NoSuchElementException e) {
                            if (!this.lenient) {
                                throw this.createException(12, Integer.toString(id));
                            }
                            this.sharedData.addOutOfTypeSystemViewMember(sofa, members[i]);
                        }
                    }
                }
                if (reindexmemberString != null) {
                    String[] members = this.parseArray(reindexmemberString);
                    for (i = 0; i < members.length; ++i) {
                        id = Integer.parseInt(members[i]);
                        if (!this.isNewFS(id)) {
                            if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                                this.disallowedViewMemberEncountered = true;
                                continue;
                            }
                            if (this.allowPreexistingFS == AllowPreexistingFS.ignore) continue;
                        }
                        try {
                            int addr = this.getFsAddrForXmiId(id);
                            indexRep.removeFS(addr);
                            indexRep.addFS(addr);
                            continue;
                        }
                        catch (NoSuchElementException e) {
                            if (!this.lenient) {
                                throw this.createException(12, Integer.toString(id));
                            }
                            this.sharedData.addOutOfTypeSystemViewMember(sofa, members[i]);
                        }
                    }
                }
            }
        }

        private void readFS(int addr, Attributes attrs) throws SAXException {
            this.currentAddr = addr;
            int id = -1;
            int typeCode = this.casBeingFilled.getHeapValue(addr);
            Type type = this.casBeingFilled.getTypeSystemImpl().ll_getTypeForCode(typeCode);
            int thisSofaNum = 0;
            try {
                id = Integer.parseInt(attrs.getValue(this.ID_ATTR_NAME));
            }
            catch (NumberFormatException e) {
                throw this.createException(5, attrs.getValue(this.ID_ATTR_NAME));
            }
            boolean newFS = this.isNewFS(id);
            if (this.sofaTypeCode == typeCode) {
                String sofaID = attrs.getValue("sofaID");
                thisSofaNum = sofaID.equals("_InitialView") || sofaID.equals("_DefaultTextSofaName") ? 1 : (newFS ? this.nextSofaNum++ : Integer.parseInt(attrs.getValue("sofaNum")));
            }
            this.featsSeen = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals(this.ID_ATTR_NAME)) {
                    try {
                        id = Integer.parseInt(attrValue);
                        newFS = this.isNewFS(id);
                        if (this.sofaTypeCode != typeCode && !newFS) {
                            this.featsSeen = new IntVector(attrs.getLength());
                            continue;
                        }
                        this.featsSeen = null;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(5, attrValue);
                    }
                }
                if (this.sofaTypeCode == typeCode && attrName.equals("sofaID")) {
                    if (attrValue.equals("_DefaultTextSofaName")) {
                        attrValue = "_InitialView";
                    }
                } else if (this.sofaTypeCode == typeCode && attrName.equals("sofaNum")) {
                    attrValue = Integer.toString(thisSofaNum);
                }
                int featCode = this.handleFeature(type, addr, attrName, attrValue, newFS);
                if (this.featsSeen == null || newFS || featCode == -1) continue;
                this.featsSeen.add(featCode);
            }
            if (this.sofaTypeCode == typeCode && newFS) {
                SofaFS sofa = (SofaFS)this.casBeingFilled.createFS(addr);
                this.casBeingFilled.getBaseIndexRepository().addFS(sofa);
                CAS view = this.casBeingFilled.getView(sofa);
                if (sofa.getSofaRef() == 1) {
                    this.casBeingFilled.registerInitialSofa();
                } else {
                    this.indexRepositories.add(this.casBeingFilled.getSofaIndexRepository(sofa));
                }
                ((CASImpl)view).registerView(sofa);
                this.views.add(view);
            }
            this.deserializedFsAddrs.add(addr);
            this.addFsAddrXmiIdMapping(addr, id);
        }

        private final boolean emptyVal(String val) {
            return val == null || val.length() == 0;
        }

        private int handleFeature(Type type, int addr, String featName, String featVal, boolean newFS) throws SAXException {
            FeatureImpl feat = (FeatureImpl)type.getFeatureByBaseName(featName);
            if (feat == null) {
                if (!this.lenient) {
                    throw this.createException(8, featName);
                }
                this.sharedData.addOutOfTypeSystemAttribute(addr, featName, featVal);
                return -1;
            }
            if (this.sofaTypeCode == this.casBeingFilled.getHeapValue(addr) && !this.isNewFS(addr)) {
                int currVal;
                if (featName.equals("sofaID") || featName.equals("sofaNum")) {
                    return feat.getCode();
                }
                if ((featName.equals("sofaString") || featName.equals("sofaURI") || featName.equals("sofaArray")) && (currVal = this.casBeingFilled.getFeatureValue(addr, feat.getCode())) != 0) {
                    return feat.getCode();
                }
            }
            this.handleFeature(addr, feat.getCode(), featVal);
            return feat.getCode();
        }

        private int handleFeature(Type type, int addr, String featName, List<String> featVals) throws SAXException {
            FeatureImpl feat = (FeatureImpl)type.getFeatureByBaseName(featName);
            if (feat == null) {
                if (!this.lenient) {
                    throw this.createException(8, featName);
                }
                this.sharedData.addOutOfTypeSystemChildElements(addr, featName, featVals);
                return -1;
            }
            this.handleFeature(addr, feat.getCode(), featVals);
            return feat.getCode();
        }

        private void handleFeature(int addr, int featCode, String featVal) throws SAXException {
            switch (this.featureType[featCode]) {
                case 1: {
                    try {
                        if (this.emptyVal(featVal)) break;
                        if (featCode == this.sofaFeatCode) {
                            int sofaXmiId = Integer.parseInt(featVal);
                            int sofaAddr = this.getFsAddrForXmiId(sofaXmiId);
                            int sofaNum = this.casBeingFilled.getFeatureValue(sofaAddr, this.sofaNumFeatCode);
                            this.casBeingFilled.setFeatureValue(addr, featCode, sofaNum);
                            break;
                        }
                        this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(9, featVal);
                    }
                }
                case 2: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    try {
                        if (this.emptyVal(featVal)) break;
                        this.casBeingFilled.setFeatureValueFromString(addr, featCode, featVal);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(10, featVal);
                    }
                }
                case 3: {
                    String origValue;
                    if (featVal == null || (origValue = this.casBeingFilled.getStringValue(addr, featCode)) != null && featVal.equals(origValue)) break;
                    this.casBeingFilled.setStringValue(addr, featCode, featVal);
                    break;
                }
                case 8: {
                    try {
                        if (this.emptyVal(featVal)) break;
                        this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(9, featVal);
                    }
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) {
                        try {
                            if (this.emptyVal(featVal)) break;
                            this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw this.createException(9, featVal);
                        }
                    }
                    if (this.featureType[featCode] == 15) {
                        int currFeatVal = this.casBeingFilled.getFeatureValue(addr, featCode);
                        int casArray = 0;
                        casArray = this.createByteArray(featVal, -1, currFeatVal);
                        if (casArray == currFeatVal) break;
                        this.casBeingFilled.setFeatureValue(addr, featCode, casArray);
                        break;
                    }
                    String[] arrayVals = this.parseArray(featVal);
                    this.handleFeature(addr, featCode, Arrays.asList(arrayVals));
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) {
                        try {
                            if (this.emptyVal(featVal)) break;
                            this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw this.createException(9, featVal);
                        }
                    }
                    String[] arrayVals = this.parseArray(featVal);
                    this.handleFeature(addr, featCode, Arrays.asList(arrayVals));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private String[] parseArray(String val) {
            String[] arrayVals = this.emptyVal(val = val.trim()) ? new String[]{} : val.split("\\s+");
            return arrayVals;
        }

        private void handleFeature(int addr, int featCode, List<String> featVals) throws SAXException {
            switch (this.featureType[featCode]) {
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (featVals.size() != 1) {
                        throw new SAXParseException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "multiple_values_unexpected", new Object[]{XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).getName()}), this.locator);
                    }
                    this.handleFeature(addr, featCode, featVals.get(0));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    int casArray = 0;
                    int currVal = this.casBeingFilled.getFeatureValue(addr, featCode);
                    casArray = this.createArray(this.casBeingFilled.getTypeSystemImpl().range(featCode), featVals, -1, currVal);
                    if (currVal != casArray) {
                        this.casBeingFilled.setFeatureValue(addr, featCode, casArray);
                    }
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) break;
                    this.addNonsharedFSToEncompassingFSMapping(casArray, addr);
                    break;
                }
                case 101: {
                    int listFS = this.casBeingFilled.getFeatureValue(addr, featCode);
                    if (listFS == 0) {
                        listFS = this.listUtils.createIntList(featVals);
                        this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    } else {
                        this.listUtils.updateIntList(listFS, featVals);
                    }
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) break;
                    this.addNonsharedFSToEncompassingFSMapping(listFS, addr);
                    break;
                }
                case 102: {
                    int listFS = this.casBeingFilled.getFeatureValue(addr, featCode);
                    if (listFS == 0) {
                        listFS = this.listUtils.createFloatList(featVals);
                        this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    } else {
                        this.listUtils.updateFloatList(listFS, featVals);
                    }
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) break;
                    this.addNonsharedFSToEncompassingFSMapping(listFS, addr);
                    break;
                }
                case 103: {
                    int listFS = this.casBeingFilled.getFeatureValue(addr, featCode);
                    if (listFS == 0) {
                        listFS = this.listUtils.createStringList(featVals);
                        this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    } else {
                        this.listUtils.updateStringList(listFS, featVals);
                    }
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) break;
                    this.addNonsharedFSToEncompassingFSMapping(listFS, addr);
                    break;
                }
                case 104: {
                    int i;
                    int listFS = this.casBeingFilled.getFeatureValue(addr, featCode);
                    IntVector fslistnodes = new IntVector();
                    if (listFS == 0) {
                        listFS = this.listUtils.createFsList(featVals, fslistnodes);
                        this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    } else {
                        this.listUtils.updateFsList(listFS, featVals, fslistnodes);
                    }
                    for (i = 0; i < fslistnodes.size(); ++i) {
                        this.fsListNodesFromMultivaluedProperties.add(fslistnodes.get(i));
                    }
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) break;
                    for (i = 0; i < fslistnodes.size(); ++i) {
                        this.addNonsharedFSToEncompassingFSMapping(fslistnodes.get(i), addr);
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private int createArray(int arrayType, List<String> values, int xmiId, int addr) {
            int casArray = -1;
            if (addr > 0) {
                if (values.size() == this.casBeingFilled.getLowLevelCAS().ll_getArraySize(addr)) {
                    casArray = addr;
                    this.updateExistingArray(arrayType, values, casArray);
                } else {
                    casArray = this.createNewArray(arrayType, values);
                }
            } else if (xmiId == -1) {
                casArray = this.createNewArray(arrayType, values);
            } else if (this.isNewFS(xmiId)) {
                casArray = this.createNewArray(arrayType, values);
            } else {
                casArray = this.getFsAddrForXmiId(xmiId);
                if (values.size() == this.casBeingFilled.getLowLevelCAS().ll_getArraySize(casArray)) {
                    this.updateExistingArray(arrayType, values, casArray);
                } else {
                    casArray = this.createNewArray(arrayType, values);
                }
            }
            this.deserializedFsAddrs.add(casArray);
            this.addFsAddrXmiIdMapping(casArray, xmiId);
            return casArray;
        }

        private int createNewArray(int arrayType, List<String> values) {
            int casArray = -1;
            FeatureStructureImpl fs = this.casBeingFilled.isIntArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createIntArrayFS(values.size())) : (this.casBeingFilled.isFloatArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createFloatArrayFS(values.size())) : (this.casBeingFilled.isStringArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createStringArrayFS(values.size())) : (this.casBeingFilled.isBooleanArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createBooleanArrayFS(values.size())) : (this.casBeingFilled.isByteArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createByteArrayFS(values.size())) : (this.casBeingFilled.isShortArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createShortArrayFS(values.size())) : (this.casBeingFilled.isLongArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createLongArrayFS(values.size())) : (this.casBeingFilled.isDoubleArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createDoubleArrayFS(values.size())) : (FeatureStructureImpl)((Object)this.casBeingFilled.createArrayFS(values.size())))))))));
            casArray = fs.getAddress();
            for (int i = 0; i < values.size(); ++i) {
                String stringVal = values.get(i);
                this.casBeingFilled.setArrayValueFromString(casArray, i, stringVal);
            }
            return casArray;
        }

        private void updateExistingArray(int arrayType, List<String> values, int casArray) {
            for (int i = 0; i < values.size(); ++i) {
                String currVal;
                String stringVal = values.get(i);
                if (this.casBeingFilled.isStringArrayType(arrayType) && (currVal = this.casBeingFilled.getLowLevelCAS().ll_getStringArrayValue(casArray, i)) != null && currVal.equals(stringVal)) continue;
                this.casBeingFilled.setArrayValueFromString(casArray, i, stringVal);
            }
        }

        private int createByteArray(String hexString, int xmiId, int addr) {
            int arrayLen = hexString.length() / 2;
            ByteArrayFS fs = null;
            if (addr > 0) {
                fs = (ByteArrayFS)this.casBeingFilled.createFS(addr);
                if (fs.size() != arrayLen) {
                    fs = this.casBeingFilled.createByteArrayFS(arrayLen);
                }
            } else if (xmiId == -1) {
                fs = this.casBeingFilled.createByteArrayFS(arrayLen);
            } else if (this.isNewFS(xmiId)) {
                fs = this.casBeingFilled.createByteArrayFS(arrayLen);
            } else {
                addr = this.getFsAddrForXmiId(xmiId);
                fs = (ByteArrayFS)this.casBeingFilled.createFS(addr);
                if (fs.size() != arrayLen) {
                    fs = this.casBeingFilled.createByteArrayFS(arrayLen);
                }
            }
            for (int i = 0; i < arrayLen; ++i) {
                byte high = this.hexCharToByte(hexString.charAt(i * 2));
                byte low = this.hexCharToByte(hexString.charAt(i * 2 + 1));
                byte b = (byte)(high << 4 | low);
                fs.set(i, b);
            }
            int arrayAddr = ((FeatureStructureImpl)((Object)fs)).getAddress();
            this.deserializedFsAddrs.add(arrayAddr);
            this.addFsAddrXmiIdMapping(arrayAddr, xmiId);
            return arrayAddr;
        }

        private byte hexCharToByte(char c) {
            if ('0' <= c && c <= '9') {
                return (byte)(c - 48);
            }
            if ('A' <= c && c <= 'F') {
                return (byte)(c - 65 + 10);
            }
            if ('1' <= c && c <= 'f') {
                return (byte)(c - 49 + 10);
            }
            throw new NumberFormatException("Invalid hex char: " + c);
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            switch (this.state) {
                case 3: {
                    this.buffer.append(chars, start, length);
                    break;
                }
            }
        }

        boolean isAllWhitespace(StringBuffer b) {
            int len = b.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(b.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void endElement(String nsURI, String localName, String qualifiedName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 3: {
                    List<String> valueList = this.multiValuedFeatures.get(qualifiedName);
                    if (valueList == null) {
                        valueList = new ArrayList<String>();
                        this.multiValuedFeatures.put(qualifiedName, valueList);
                    }
                    valueList.add(this.buffer.toString());
                    this.state = 2;
                    break;
                }
                case 5: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (this.outOfTypeSystemElement != null) {
                        if (!this.multiValuedFeatures.isEmpty()) {
                            for (Map.Entry<String, List<String>> entry : this.multiValuedFeatures.entrySet()) {
                                String featName = entry.getKey();
                                List<String> featVals = entry.getValue();
                                this.addOutOfTypeSystemFeature(this.outOfTypeSystemElement, featName, featVals);
                            }
                        }
                        this.outOfTypeSystemElement = null;
                    } else if (this.currentType != null) {
                        if (this.casBeingFilled.isArrayType(this.currentType) && !this.casBeingFilled.isByteArrayType(this.currentType)) {
                            if (this.currentArrayElements == null) {
                                this.currentArrayElements = this.multiValuedFeatures.get("elements");
                                if (this.currentArrayElements == null) {
                                    this.currentArrayElements = Collections.emptyList();
                                }
                            }
                            this.createArray(this.currentType.getCode(), this.currentArrayElements, this.currentArrayId, 0);
                        } else if (!this.multiValuedFeatures.isEmpty()) {
                            for (Map.Entry<String, List<String>> entry : this.multiValuedFeatures.entrySet()) {
                                List<String> featVals;
                                String featName = entry.getKey();
                                int featcode = this.handleFeature(this.currentType, this.currentAddr, featName, featVals = entry.getValue());
                                if (featcode == -1 || this.featsSeen == null) continue;
                                this.featsSeen.add(featcode);
                            }
                        }
                        if (this.sofaTypeCode != this.currentType.getCode() && this.featsSeen != null) {
                            int[] feats = this.casBeingFilled.getTypeSystemImpl().ll_getAppropriateFeatures(this.currentType.getCode());
                            for (int i = 0; i < feats.length; ++i) {
                                if (this.featsSeen.contains(feats[i])) continue;
                                this.casBeingFilled.setFeatureValue(this.currentAddr, feats[i], 0);
                            }
                            this.featsSeen = null;
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    --this.ignoreDepth;
                    if (this.ignoreDepth != 0) break;
                    this.state = 1;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            int i;
            for (i = 0; i < this.deserializedFsAddrs.size(); ++i) {
                this.finalizeFS(this.deserializedFsAddrs.get(i));
            }
            for (i = 0; i < this.fsListNodesFromMultivaluedProperties.size(); ++i) {
                this.remapFSListHeads(this.fsListNodesFromMultivaluedProperties.get(i));
            }
            for (i = 0; i < this.views.size(); ++i) {
                ((CASImpl)this.views.get(i)).updateDocumentAnnotation();
            }
            if (this.disallowedViewMemberEncountered) {
                CASRuntimeException e = new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", new String[]{"Preexisting FS view member encountered."});
                throw e;
            }
        }

        private void finalizeFS(int addr) throws SAXParseException {
            int type = this.casBeingFilled.getHeapValue(addr);
            if (this.casBeingFilled.isArrayType(type)) {
                this.finalizeArray(type, addr);
                return;
            }
            int[] feats = this.casBeingFilled.getTypeSystemImpl().ll_getAppropriateFeatures(type);
            for (int i = 0; i < feats.length; ++i) {
                int featVal;
                Feature feat = XmiCasDeserializer.this.ts.ll_getFeatureForCode(feats[i]);
                int typeCode = XmiCasDeserializer.this.ts.ll_getRangeType(feats[i]);
                if (!this.casBeingFilled.ll_isRefType(typeCode) || this.featureType[feats[i]] != 8 && !feat.isMultipleReferencesAllowed() || (featVal = this.casBeingFilled.getFeatureValue(addr, feats[i])) == 0) continue;
                int fsValAddr = 0;
                try {
                    fsValAddr = this.getFsAddrForXmiId(featVal);
                }
                catch (NoSuchElementException e) {
                    if (!this.lenient) {
                        throw this.createException(12, Integer.toString(featVal));
                    }
                    this.sharedData.addOutOfTypeSystemAttribute(addr, feat.getShortName(), Integer.toString(featVal));
                }
                this.casBeingFilled.setFeatureValue(addr, feats[i], fsValAddr);
            }
        }

        private void remapFSListHeads(int addr) throws SAXParseException {
            int type = this.casBeingFilled.getHeapValue(addr);
            if (!this.listUtils.isFsListType(type)) {
                return;
            }
            int[] feats = this.casBeingFilled.getTypeSystemImpl().ll_getAppropriateFeatures(type);
            if (feats.length == 0) {
                return;
            }
            int headFeat = feats[0];
            int featVal = this.casBeingFilled.getFeatureValue(addr, headFeat);
            if (featVal != 0) {
                int fsValAddr = 0;
                try {
                    fsValAddr = this.getFsAddrForXmiId(featVal);
                }
                catch (NoSuchElementException e) {
                    if (!this.lenient) {
                        throw this.createException(12, Integer.toString(featVal));
                    }
                    this.sharedData.addOutOfTypeSystemAttribute(addr, "head", Integer.toString(featVal));
                }
                this.casBeingFilled.setFeatureValue(addr, headFeat, fsValAddr);
            }
        }

        private void finalizeArray(int type, int addr) throws SAXParseException {
            if (!this.casBeingFilled.isFSArrayType(type)) {
                return;
            }
            int size = this.casBeingFilled.ll_getArraySize(addr);
            for (int i = 0; i < size; ++i) {
                int arrayVal = this.casBeingFilled.getArrayValue(addr, i);
                if (arrayVal == 0) continue;
                int arrayValAddr = 0;
                try {
                    arrayValAddr = this.getFsAddrForXmiId(arrayVal);
                }
                catch (NoSuchElementException e) {
                    if (!this.lenient) {
                        throw this.createException(12, Integer.toString(arrayVal));
                    }
                    this.sharedData.addOutOfTypeSystemArrayElement(addr, i, arrayVal);
                }
                this.casBeingFilled.setArrayValue(addr, i, arrayValAddr);
            }
        }

        private XCASParsingException createException(int code) {
            XCASParsingException e = new XCASParsingException(code);
            String source = unknownXMLSource;
            String line = unknownXMLSource;
            String col = unknownXMLSource;
            if (this.locator != null) {
                source = this.locator.getSystemId();
                if (source == null) {
                    source = this.locator.getPublicId();
                }
                if (source == null) {
                    source = unknownXMLSource;
                }
                line = Integer.toString(this.locator.getLineNumber());
                col = Integer.toString(this.locator.getColumnNumber());
            }
            e.addArgument(source);
            e.addArgument(line);
            e.addArgument(col);
            return e;
        }

        private XCASParsingException createException(int code, String arg) {
            XCASParsingException e = this.createException(code);
            e.addArgument(arg);
            return e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator loc) {
            this.locator = loc;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        private final int classifyType(int type) {
            if (this.listUtils.isIntListType(type)) {
                return 101;
            }
            if (this.listUtils.isFloatListType(type)) {
                return 102;
            }
            if (this.listUtils.isStringListType(type)) {
                return 103;
            }
            if (this.listUtils.isFsListType(type)) {
                return 104;
            }
            return this.casBeingFilled.ll_getTypeClass(type);
        }

        private void addFsAddrXmiIdMapping(int fsAddr, int xmiId) {
            if (xmiId > 0) {
                if (this.mergePoint < 0) {
                    this.sharedData.addIdMapping(fsAddr, xmiId);
                } else {
                    this.localXmiIdToFsAddrMap.put(xmiId, fsAddr);
                }
            }
        }

        private int getFsAddrForXmiId(int xmiId) {
            if (this.mergePoint < 0 || !this.isNewFS(xmiId)) {
                int addr = this.sharedData.getFsAddrForXmiId(xmiId);
                if (addr > 0) {
                    return addr;
                }
                throw new NoSuchElementException();
            }
            Integer localAddr = this.localXmiIdToFsAddrMap.get(xmiId);
            if (localAddr != null) {
                return localAddr;
            }
            throw new NoSuchElementException();
        }

        private void addToOutOfTypeSystemData(XmlElementName xmlElementName, Attributes attrs) throws XCASParsingException {
            this.outOfTypeSystemElement = new XmiSerializationSharedData.OotsElementData();
            this.outOfTypeSystemElement.elementName = xmlElementName;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals(this.ID_ATTR_NAME)) {
                    this.outOfTypeSystemElement.xmiId = attrValue;
                    continue;
                }
                this.outOfTypeSystemElement.attributes.add(new XmlAttribute(attrName, attrValue));
            }
            this.sharedData.addOutOfTypeSystemElement(this.outOfTypeSystemElement);
        }

        private void addOutOfTypeSystemFeature(XmiSerializationSharedData.OotsElementData ootsElem, String featName, List<String> featVals) {
            Iterator<String> iter = featVals.iterator();
            XmlElementName elemName = new XmlElementName(null, featName, featName);
            while (iter.hasNext()) {
                ootsElem.childElements.add(new XmlElementNameAndContents(elemName, iter.next()));
            }
        }

        private boolean isNewFS(int id) {
            return id > this.mergePoint;
        }

        private void addNonsharedFSToEncompassingFSMapping(int nonsharedFS, int encompassingFS) {
            this.sharedData.addNonsharedRefToFSMapping(nonsharedFS, encompassingFS);
        }
    }
}

