/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import org.apache.uima.cas.impl.CommonAuxHeap;

final class ShortHeap
extends CommonAuxHeap {
    short[] heap;

    ShortHeap() {
        super(16, 524288);
    }

    ShortHeap(int heapBaseSize, int heapMultLimit) {
        super(heapBaseSize, heapMultLimit);
    }

    @Override
    final void initMemory() {
        this.heap = new short[this.heapBaseSize];
    }

    @Override
    void growHeapIfNeeded() {
        if (this.heap.length >= this.heapPos) {
            return;
        }
        short[] new_array = new short[this.computeNewArraySize(this.heap.length, this.heapPos, 2, this.heapMultLimit)];
        System.arraycopy(this.heap, 0, new_array, 0, this.heap.length);
        this.heap = new_array;
    }

    @Override
    void resetToZeros() {
        Arrays.fill(this.heap, 0, this.heapPos, (short)0);
    }

    short getHeapValue(int offset) {
        return this.heap[offset];
    }

    void setHeapValue(short val, int pos) {
        this.heap[pos] = val;
    }

    int addShort(short val) {
        int pos = this.reserve(1);
        this.heap[pos] = val;
        return pos;
    }

    protected void reinit(short[] shortHeap) {
        int argLength = shortHeap.length;
        if (argLength > this.heap.length) {
            this.heap = new short[argLength];
        }
        System.arraycopy(shortHeap, 0, this.heap, 0, argLength);
        this.heapPos = argLength;
    }
}

