/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util;

import net.didion.jwnl.JWNL;
import net.didion.jwnl.util.MessageLogLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageLog {
    private Log _log;

    public MessageLog(Class clazz) {
        this._log = LogFactory.getLog(clazz);
    }

    public void log(MessageLogLevel level, String messageKey) {
        this.doLog(level, JWNL.resolveMessage(messageKey));
    }

    public void log(MessageLogLevel level, String messageKey, Object param) {
        this.doLog(level, JWNL.resolveMessage(messageKey, param));
    }

    public void log(MessageLogLevel level, String messageKey, Object[] params) {
        this.doLog(level, JWNL.resolveMessage(messageKey, params));
    }

    public void log(MessageLogLevel level, String messageKey, Throwable t) {
        this.doLog(level, JWNL.resolveMessage(messageKey), t);
    }

    public void log(MessageLogLevel level, String messageKey, Object param, Throwable t) {
        this.doLog(level, JWNL.resolveMessage(messageKey, param), t);
    }

    public void log(MessageLogLevel level, String messageKey, Object[] params, Throwable t) {
        this.doLog(level, JWNL.resolveMessage(messageKey, params), t);
    }

    public boolean isLevelEnabled(MessageLogLevel level) {
        if (level == MessageLogLevel.TRACE) {
            return this._log.isTraceEnabled();
        }
        if (level == MessageLogLevel.DEBUG) {
            return this._log.isDebugEnabled();
        }
        if (level == MessageLogLevel.INFO) {
            return this._log.isInfoEnabled();
        }
        if (level == MessageLogLevel.WARN) {
            return this._log.isWarnEnabled();
        }
        if (level == MessageLogLevel.ERROR) {
            return this._log.isErrorEnabled();
        }
        if (level == MessageLogLevel.FATAL) {
            return this._log.isFatalEnabled();
        }
        return false;
    }

    private void doLog(MessageLogLevel level, String message) {
        if (this.isLevelEnabled(level)) {
            if (level == MessageLogLevel.TRACE) {
                this._log.trace(message);
            } else if (level == MessageLogLevel.DEBUG) {
                this._log.debug(message);
            } else if (level == MessageLogLevel.INFO) {
                this._log.info(message);
            } else if (level == MessageLogLevel.WARN) {
                this._log.warn(message);
            } else if (level == MessageLogLevel.ERROR) {
                this._log.error(message);
            } else if (level == MessageLogLevel.FATAL) {
                this._log.fatal(message);
            }
        }
    }

    private void doLog(MessageLogLevel level, String message, Throwable t) {
        if (this.isLevelEnabled(level)) {
            if (level == MessageLogLevel.TRACE) {
                this._log.trace(message, t);
            } else if (level == MessageLogLevel.DEBUG) {
                this._log.debug(message, t);
            } else if (level == MessageLogLevel.INFO) {
                this._log.info(message, t);
            } else if (level == MessageLogLevel.WARN) {
                this._log.warn(message, t);
            } else if (level == MessageLogLevel.ERROR) {
                this._log.error(message, t);
            } else if (level == MessageLogLevel.FATAL) {
                this._log.fatal(message, t);
            }
        }
    }
}

