/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.util;

import cc.mallet.types.Matrix;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.Matrixn;
import cc.mallet.types.SparseMatrixn;
import java.util.Arrays;

public class Matrices {
    public static Matrix diag(int[] sizes, double v) {
        int maxN = MatrixOps.max(sizes);
        double[] vals = new double[maxN];
        Arrays.fill(vals, v);
        int[] idxs = new int[maxN];
        for (int i = 0; i < idxs.length; ++i) {
            int[] oneIdx = new int[sizes.length];
            Arrays.fill(oneIdx, i);
            idxs[i] = Matrixn.singleIndex(sizes, oneIdx);
        }
        return new SparseMatrixn(sizes, idxs, vals);
    }

    public static Matrix constant(int[] sizes, double v) {
        int singleSize = 1;
        for (int i = 0; i < sizes.length; ++i) {
            singleSize *= sizes[i];
        }
        double[] vals = new double[singleSize];
        Arrays.fill(vals, v);
        return new SparseMatrixn(sizes, vals);
    }
}

