/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.NormalFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import gnu.trove.TDoubleArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;

public class TestNormalFactor
extends TestCase {
    public TestNormalFactor(String name) {
        super(name);
    }

    public void testSample() {
        Variable v1 = new Variable(-1);
        Variable v2 = new Variable(-1);
        Randoms r = new Randoms(2343);
        DenseVector mu = new DenseVector(new double[]{1.0, 2.0});
        DenseMatrix var = new DenseMatrix(new double[][]{{0.5, 2.0}, {0.0, 1.0}});
        HashVarSet vars = new HashVarSet(new Variable[]{v1, v2});
        NormalFactor f = new NormalFactor(vars, mu, var);
        TDoubleArrayList v1lst = new TDoubleArrayList();
        TDoubleArrayList v2lst = new TDoubleArrayList();
        for (int i = 0; i < 100000; ++i) {
            Assignment assn = f.sample(r);
            v1lst.add(assn.getDouble(v1));
            v2lst.add(assn.getDouble(v2));
        }
        this.checkMeanStd(v1lst, 1.0, Math.sqrt(2.0));
        this.checkMeanStd(v2lst, 2.0, Math.sqrt(1.3333333333333333));
    }

    void checkMeanStd(TDoubleArrayList ell, double mu, double sigma) {
        double[] vals = ell.toNativeArray();
        double mean1 = MatrixOps.mean(vals);
        double std1 = MatrixOps.stddev(vals);
        TestNormalFactor.assertEquals((double)mu, (double)mean1, (double)0.025);
        TestNormalFactor.assertEquals((double)sigma, (double)std1, (double)0.01);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNormalFactor.class);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestNormalFactor(args[i]));
            }
        } else {
            theSuite = TestNormalFactor.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

