/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.factory.FsIndexFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasIOUtils;

public final class CasFactory {
    private CasFactory() {
    }

    public static CAS createText(String aText) throws UIMAException {
        return CasFactory.createText(aText, null);
    }

    public static CAS createText(String aText, String aLanguage) throws UIMAException {
        CAS cas = CasFactory.createCas();
        if (aText != null) {
            cas.setDocumentText(aText);
        }
        if (aLanguage != null) {
            cas.setDocumentLanguage(aLanguage);
        }
        return cas;
    }

    public static CAS createCas() throws UIMAException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        TypePriorities tp = TypePrioritiesFactory.createTypePriorities();
        FsIndexCollection indexes = FsIndexFactory.createFsIndexCollection();
        ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
        return CasCreationUtils.createCas(tsd, tp, indexes.getFsIndexes(), null, resMgr);
    }

    public static CAS createCas(String ... typeSystemDescriptorNames) throws UIMAException {
        return CasCreationUtils.createCas(TypeSystemDescriptionFactory.createTypeSystemDescription(typeSystemDescriptorNames), null, null);
    }

    public static CAS createCasFromPath(String ... typeSystemDescriptorPaths) throws UIMAException {
        return CasFactory.createCas(TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath(typeSystemDescriptorPaths));
    }

    public static CAS createCas(TypeSystemDescription typeSystemDescription) throws UIMAException {
        return CasCreationUtils.createCas(typeSystemDescription, null, null);
    }

    public static CAS createCas(String fileName, TypeSystemDescription typeSystemDescription) throws UIMAException, IOException {
        CAS cas = CasFactory.createCas(typeSystemDescription);
        try (FileInputStream is = new FileInputStream(fileName);){
            CasIOUtils.load(is, cas);
        }
        return cas;
    }
}

