/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleSet
extends ResourceBundle {
    private Locale _locale = Locale.getDefault();
    private List _resources = new ArrayList();

    public ResourceBundleSet(String resource) {
        this.addResource(resource);
    }

    public ResourceBundleSet(String[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            this.addResource(resources[i]);
        }
    }

    public void addResource(String resource) {
        this._resources.add(resource);
    }

    public String[] getResources() {
        return this._resources.toArray(new String[this._resources.size()]);
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    @Override
    protected Object handleGetObject(String key) {
        Iterator itr = this._resources.iterator();
        while (itr.hasNext()) {
            try {
                ResourceBundle bundle = this.getBndl((String)itr.next());
                String msg = bundle.getString(key);
                if (msg == null) continue;
                return msg;
            }
            catch (Exception exception) {
            }
        }
        return key;
    }

    public Enumeration getKeys() {
        return new Enumeration(){
            private Iterator _itr;
            private Enumeration _currentEnum;
            {
                this._itr = ResourceBundleSet.this._resources.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                if ((this._currentEnum == null || !this._currentEnum.hasMoreElements()) && this._itr.hasNext()) {
                    this._currentEnum = ResourceBundleSet.this.getBndl((String)this._itr.next()).getKeys();
                }
                if (this._currentEnum != null) {
                    return this._currentEnum.hasMoreElements();
                }
                return false;
            }

            public Object nextElement() {
                return this._currentEnum.nextElement();
            }
        };
    }

    private ResourceBundle getBndl(String bundle) {
        return ResourceBundle.getBundle(bundle, this._locale);
    }
}

