/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class StringUtil {
    public static Properties appendProperties(Properties source, Properties plus, boolean override) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)source);
        Enumeration<?> plusNames = plus.propertyNames();
        while (plusNames.hasMoreElements()) {
            String name = (String)plusNames.nextElement();
            String value = plus.getProperty(name);
            if (result.getProperty(name) != null && !override) continue;
            result.setProperty(name, value);
        }
        return result;
    }

    public static int countWords(String text) {
        int wordCounter = text.trim().length() > 0 ? 1 : 0;
        for (int i = 0; i < text.length(); ++i) {
            char prevChar = i > 0 ? text.charAt(i - 1) : (char)'\u0000';
            char currChar = text.charAt(i);
            if (Character.isWhitespace(currChar) || !Character.isWhitespace(prevChar)) continue;
            ++wordCounter;
        }
        return wordCounter;
    }

    public static String errorStackTraceContent(Throwable error) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        error.printStackTrace(pWriter);
        return sWriter.toString();
    }

    public static String extractTextFromMarkup(String mString) {
        StringBuffer buffer = new StringBuffer();
        boolean mSection = false;
        for (int i = 0; i < mString.length(); ++i) {
            char ch = mString.charAt(i);
            if (ch == '<') {
                mSection = true;
                continue;
            }
            if (mSection) {
                if (ch != '>') continue;
                mSection = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String getPlainClassName(Class<?> aClass) {
        int index = aClass.getName().lastIndexOf(46);
        return index > 0 ? aClass.getName().substring(index + 1) : aClass.getName();
    }

    public static boolean isLowerCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int indexOfIgnoreCase(String mainStr, String argStr) {
        String source = mainStr.toLowerCase();
        String pattern = argStr.toLowerCase();
        int index = source.indexOf(pattern);
        return index;
    }

    public static int indexOfIgnoreCase(String mainStr, String argStr, int fromIndex) {
        String source = mainStr.toLowerCase();
        String pattern = argStr.toLowerCase();
        int index = source.indexOf(pattern, fromIndex);
        return index;
    }

    public static String toRegExpReplacement(String string) {
        String replacement = string.replaceAll("\\\\", "\\\\\\\\");
        replacement = replacement.replaceAll("\\$", "\\\\\\$");
        return replacement;
    }

    public static String toRegExpString(String string) {
        char[] chars2escape = new char[]{'.', '$', '^', '{', '[', '(', '|', ')', '*', '+', '?'};
        String regExString = string.replaceAll("\\\\", "\\\\\\\\");
        StringBuffer escBuff = new StringBuffer();
        StringBuffer repBuff = new StringBuffer();
        for (int i = 0; i < chars2escape.length; ++i) {
            escBuff.setLength(0);
            repBuff.setLength(0);
            escBuff.append("\\");
            escBuff.append(chars2escape[i]);
            repBuff.append("\\\\");
            repBuff.append(escBuff);
            regExString = regExString.replaceAll(escBuff.toString(), repBuff.toString());
        }
        return regExString;
    }
}

