/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonArray_Type;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;

public final class StringArray_Type
extends CommonArray_Type {
    public static final int typeIndexID = StringArray.typeIndexID;
    private final FSGenerator fsGenerator = new FSGenerator(){

        @Override
        public FeatureStructure createFS(int addr, CASImpl cas) {
            if (StringArray_Type.this.useExistingInstance) {
                TOP fs = StringArray_Type.this.jcas.getJfsFromCaddr(addr);
                if (null == fs) {
                    fs = new StringArray(addr, StringArray_Type.this);
                    StringArray_Type.this.jcas.putJfsFromCaddr(addr, fs);
                    return fs;
                }
                return fs;
            }
            return new StringArray(addr, StringArray_Type.this);
        }
    };

    @Override
    protected FSGenerator getFSGenerator() {
        return this.fsGenerator;
    }

    private StringArray_Type() {
    }

    public StringArray_Type(JCas jcas, Type casType) {
        super(jcas, casType);
        this.casImpl.getFSClassRegistry().addGeneratorForType((TypeImpl)this.casType, this.getFSGenerator());
    }

    public String get(int addr, int i) {
        if (this.lowLevelTypeChecks) {
            return this.ll_cas.ll_getStringArrayValue(addr, i, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        return this.ll_cas.ll_getStringArrayValue(addr, i);
    }

    public void set(int addr, int i, String v) {
        if (this.lowLevelTypeChecks) {
            this.ll_cas.ll_setStringArrayValue(addr, i, v, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        this.ll_cas.ll_setStringArrayValue(addr, i, v);
    }

    public void copyFromArray(int addr, String[] src, int srcOffset, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, destOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            this.ll_cas.ll_setStringArrayValue(addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int addr, int srcOffset, String[] dest, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, srcOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.ll_cas.ll_getStringArrayValue(addr, i + srcOffset);
        }
    }

    public String[] toArray(int addr) {
        int size = this.size(addr);
        String[] outArray = new String[size];
        this.copyToArray(addr, 0, outArray, 0, size);
        return outArray;
    }
}

